#include "mbed.h"

//SDA , SCL
I2C i2cBus(I2C_SDA, I2C_SCL);

int main()
{
    i2cBus.frequency(100000);

    printf("\r\n Scanning for I2C devices (addresses in hex)\r\n ");
    printf("    0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\r\n");
    for (int i = 0; i < 128; i += 16) {
        printf("%02x: ", i);
        for(int j = 0; j < 16; j++) {
            // Skip unwanted addresses
            if (i+j < 0x3 || i+j > 0x77) {
                printf("   ");
                continue;
            }

            if (!i2cBus.write(i+j<<1, NULL, 0))
                printf("%02x ", i+j);
            else
                printf("-- ");

        }
        printf("\r\n");
    }
}

