#include "mbed.h"
#include "ili9328.h"

// prepare the data bus for writing commands and pixel data
BusOut dataBus( D8, D9, D2, D3, D4, D5, D6, D7 ); // 8 pins
// create the lcd instance
ILI9328_LCD lcd( A3,  A4, A2,A1, &dataBus, NC, A0); // control pins and data bus
//ILI9328_LCD(  CS,  RESET,  RS, WR, BusOut* DATA_PORT, PinName BL = NC,  RD );
   
int main()
{
    int ii,height,width;
    
    height = lcd.GetHeight();
    width =  lcd.GetWidth();
    // initialize display - place it in standard portrait mode and set background to black and
    //                      foreground to white color.
    lcd.Initialize();

    // print something on the screen
    lcd.Print( "Hello, World!", CENTER, 50); // align text to center horizontally and use starndard colors
 
    wait(2);
   
    lcd.ClearScreen();
 
    for(ii=0;ii<width;ii++)
    {
        lcd.DrawLine(0, 0, height, ii,COLOR_GREEN);
        ii = ii+10;    
    }
    wait(2);
 
    lcd.DrawCircle(height/4, width/4, 20, COLOR_GREEN);
    wait(2);
 
    lcd.FillCircle(height/2, width/2, 50, COLOR_GREEN);
    wait(2);
 
    lcd.FillTriangle(height/4, width/4,(height/4)+20, (width/4)+40,(height/4)-20, (width/4)+40, COLOR_RED);
 
    while ( 1 ) { }
}