#include "mbed.h"
#include "mlx90614.h"

I2C  mlx90614_i2c(PD_12, PD_10); // I2C1_SDA, I2C1_SCL

void MLX90614_WriteByte(uint8_t MLX90614_reg, uint8_t MLX90614_data)
{
    char data_out[2];
    data_out[0]= MLX90614_reg;
    data_out[1]= MLX90614_data;
    mlx90614_i2c.write(MLX90614_slave_addr, data_out, 2, 0);
}

uint16_t MLX90614_ReadByte(uint8_t MLX90614_reg)
{
    char data_out[1], data_in[3];
    data_out[0] = MLX90614_reg;
    mlx90614_i2c.write(MLX90614_slave_addr, data_out, 1, 1);
    mlx90614_i2c.read(MLX90614_slave_addr, data_in, 3, 0);
    return ((data_in[1]<<8)+data_in[0]);
}

uint16_t MLX90614::getTA()
{
    uint16_t t;
    t = MLX90614_ReadByte(MLX90614_TA); // Ambient Temperature
    return ((t*2) - 27315) /100;
}

uint16_t MLX90614::getTOBJ1()
{
    uint16_t t;
    t = MLX90614_ReadByte(MLX90614_TOBJ1); // Object Temperature 1
    return ((t*2) - 27315) /100;
}
