// using NuMaker-PFM-NUC472 I2C1 to draw a moving circle on LCD
#include "mbed.h"
#include "math.h"
#include "ssd1306.h"
#include "draw2D.h"

#define PI 3.1415926535

#define X0 15       // Circle initial X 
#define Y0 10       // Circle initial Y

I2C i2c1(PD_12, PD_10); // I2C1_SDA, I2C1_SCL

SSD1306 LCD; // LCD connected on I2C1
Draw2D  D2D;  // Draw2D library

int main() {
    
    int dirX, dirY;
    int movX, movY;
    int r;
    int x, y;
    
    i2c1.frequency(400000); 
    
    LCD.initialize();
    LCD.clearscreen();

    x = X0;   // circle center x
    y = Y0;   // circle center y
    r = 3;    // circle radius
    
    movX = 3; // x movement
    movY = 3; // y movement
    dirX = 1; // x direction
    dirY = 1; // y direction
            
    while(true) {
       D2D.drawCircle(x, y, r, FG_COLOR, BG_COLOR); // draw a circle
       
       Thread::wait(1); // Delay for Vision
                     
       D2D.drawCircle(x, y, r, BG_COLOR, BG_COLOR); // erase a circle

       x = x + dirX * movX; // change x of circle center
       y = y + dirY * movY; // change y of circle center 
              
       // boundary check for changing direction       
       if      ((x-r) <=0)        {dirX= 1; x= x + dirX*movX;}
       else if ((x+r) >=LCD_Xmax) {dirX=-1; x= x + dirX*movX;}
       
       if      ((y-r) <=0)        {dirY= 1; y= y + dirY*movY;}
       else if ((y+r) >=LCD_Ymax) {dirY=-1; y= y + dirY*movY;}                    
   }       
}
