#ifndef __NRF24L01P_H__
#define __NRF24L01P_H__

/*
 * You can configure the nRF24L01+ in power down, standby, RX or TX mode.
 */
#define NRF24L01P_MODE_UNKNOWN      0x0
#define NRF24L01P_MODE_POR          0x1
#define NRF24L01P_MODE_POWER_DOWN   0x2
#define NRF24L01P_MODE_STANDBY      0x3
#define NRF24L01P_MODE_RX           0x4
#define NRF24L01P_MODE_TX           0x5

#define REG_BIT_0    (1 << 0)
#define REG_BIT_1    (1 << 1)
#define REG_BIT_2    (1 << 2)
#define REG_BIT_3    (1 << 3)
#define REG_BIT_4    (1 << 4)
#define REG_BIT_5    (1 << 5)
#define REG_BIT_6    (1 << 6)
#define REG_BIT_7    (1 << 7)

#define  NRF24L01P_TX_PWR_MINUS_18_DB  0x0
#define  NRF24L01P_TX_PWR_MINUS_12_DB  0x1
#define  NRF24L01P_TX_PWR_MINUS_6_DB   0x2
#define  NRF24L01P_TX_PWR_ZERO_DB      0x3

/*
 * The following FIFOs are present in nRF24L01+:
 *  > TX three level, 32 byte FIFO
 *  > RX three level, 32 byte FIFO
 */
#define NRF24L01P_TX_FIFO_COUNT   3
#define NRF24L01P_RX_FIFO_COUNT   3

#define NRF24L01P_TX_FIFO_SIZE  32
#define NRF24L01P_RX_FIFO_SIZE  32

#define NRF24L01P_SPI_MAX_DATA_RATE_MBPS   10


#define NRF24L01P_DR_250_KBPS   250
#define NRF24L01P_DR_1_MBPS     1000
#define NRF24L01P_DR_2_MBPS     2000

#define NRF24L01P_MIN_CHAN_FREQ     2400
#define NRF24L01P_MAX_CHAN_FREQ     2520


#define NRF24L01P_MIN_PYLD_LEN   0
#define NRF24L01P_MAX_PYLD_LEN   32

#define NRF24L01P_SPI_CMD_RD_REG            0x00
#define NRF24L01P_SPI_CMD_WR_REG            0x20
#define NRF24L01P_SPI_CMD_RD_RX_PYLD        0x61   
#define NRF24L01P_SPI_CMD_WR_TX_PYLD        0xa0
#define NRF24L01P_SPI_CMD_FLUSH_TX          0xe1
#define NRF24L01P_SPI_CMD_FLUSH_RX          0xe2
#define NRF24L01P_SPI_CMD_REUSE_TX_PL       0xe3
#define NRF24L01P_SPI_CMD_R_RX_PL_WID       0x60
#define NRF24L01P_SPI_CMD_W_ACK_PYLD        0xa8
#define NRF24L01P_SPI_CMD_W_TX_PYLD_NO_ACK  0xb0
#define NRF24L01P_SPI_CMD_NOP               0xff


#define NRF24L01P_REG_CONFIG              0x00
#define NRF24L01P_REG_EN_AA               0x01
#define NRF24L01P_REG_EN_RX_ADDR          0x02
#define NRF24L01P_REG_SETUP_AW            0x03
#define NRF24L01P_REG_SETUP_RETR          0x04
#define NRF24L01P_REG_RF_CH               0x05
#define NRF24L01P_REG_RF_SETUP            0x06
#define NRF24L01P_REG_STATUS              0x07
#define NRF24L01P_REG_OBSERVE_TX          0x08
#define NRF24L01P_REG_RPD                 0x09
#define NRF24L01P_REG_RX_ADDR_P0          0x0a
#define NRF24L01P_REG_RX_ADDR_P1          0x0b
#define NRF24L01P_REG_RX_ADDR_P2          0x0c
#define NRF24L01P_REG_RX_ADDR_P3          0x0d
#define NRF24L01P_REG_RX_ADDR_P4          0x0e
#define NRF24L01P_REG_RX_ADDR_P5          0x0f
#define NRF24L01P_REG_TX_ADDR             0x10
#define NRF24L01P_REG_RX_PW_P0            0x11
#define NRF24L01P_REG_RX_PW_P1            0x12
#define NRF24L01P_REG_RX_PW_P2            0x13
#define NRF24L01P_REG_RX_PW_P3            0x14
#define NRF24L01P_REG_RX_PW_P4            0x15
#define NRF24L01P_REG_RX_PW_P5            0x16
#define NRF24L01P_REG_FIFO_STATUS         0x17
#define NRF24L01P_REG_DYNPD               0x1c
#define NRF24L01P_REG_FEATURE             0x1d

#define RF24L01P_RX_ADDR_REG_LEN     5
#define RF24L01P_TX_ADDR_REG_LEN     5

#define NRF24L01P_RF_SETUP_REG_DR_HIGH_BIT  (1 << 3)
#define NRF24L01P_RF_SETUP_REG_DR_LOW_BIT   (1 << 5)

#endif
