#include "mbed.h"
#include "rtos.h"

#define MAX_VOLTAGE 12.0
#define PROGRAM_RUNTIME 1000.0
#define PWM_PERIOD 10 // 10ms pwm period
#define APPLIED_VOLTAGE 12.0
#define HALF_PERIOD_DURATION 250 //ms

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut dOut1(p21), dOut2(p22);
PwmOut pwmPump(p23);

Timer ctrlTimer;
bool active = false;
    
void setVoltage(float inputVoltage)
{
    if(inputVoltage<0.0) {
        inputVoltage = -inputVoltage;
        dOut1=0;
        dOut2=1;
    } else {
        dOut1=1;
        dOut2=0;
    }
    float dutyCycle = inputVoltage/MAX_VOLTAGE;
    dutyCycle = (dutyCycle > 1.0)? 1.0 : dutyCycle;
    pwmPump.write(dutyCycle);
}

void computing(void const *args) {

    pwmPump.period_ms(PWM_PERIOD);
    bool l_switched = false;
    float appliedVoltage = 0.0;
    while (true) {
    
        if (active) {
    
            if(l_switched) {
                appliedVoltage = APPLIED_VOLTAGE;
                l_switched = false;
            } else {
                appliedVoltage = -APPLIED_VOLTAGE;
                l_switched = true;
            }
        }
        else{
         appliedVoltage = 0.0;
        }
        pc.printf("%f Volts\n",appliedVoltage);
        setVoltage(appliedVoltage);
        //pc.printf("PWM Duty Cyle: %f\n",pwmPump.read());
        Thread::wait(HALF_PERIOD_DURATION);
    }
}

int main(void)
{
    ctrlTimer.start(); 
    pc.printf("Started computing thread!\n");   
    Thread thrd2(computing,NULL,osPriorityAboveNormal);

 
    //pc.printf("Press 'b' to start, 's' to stop\n");
    //char c;
    active = true;
    while (ctrlTimer.read() < PROGRAM_RUNTIME) {
//        c = pc.getc();
//        
//        if(c == 'b') {
//            active = true;
//            pc.printf("Started!\n");
//        }
//        if(c == 's') {
//            active = false;
//            pc.printf("Stopped!\n");
//        }
        
        Thread::wait(500);
    }
    
    
    setVoltage(0.0);
    thrd2.terminate();
    pc.printf("Program exits!\n");
    return 0;
}