#include "mbed.h"
#include "MODSERIAL.h"
#include <math.h>
#include "BNO055.h"

#define PC_BAUD 9600
//#define BT_BAUD 115200

//#define TX_PIN p13
//#define RX_PIN p14
#define IMU_SDA p28
#define IMU_SCL p27
#define PI 3.14159265

BNO055 imu(p28,p27);

//MODSERIAL bt(TX_PIN, RX_PIN);
MODSERIAL pc(USBTX,USBRX);

//for calibrating IMU
//for IMU1:
char cal_vals[22] = {255, 255, 220, 255, 13, 0, 83, 255, 36, 1, 80, 0, 253, 255, 0, 0, 1, 0, 232, 3, 235, 2};

bool newline_detected = false;
bool newline_sent = false;

void setCal(){
    imu.write_calibration_data();
}

// Called everytime a new character goes into
// the RX buffer. Test that character for \n
// Note, rxGetLastChar() gets the last char that
// we received but it does NOT remove it from
// the RX buffer.
void rxCallback(MODSERIAL_IRQ_INFO *q)
{
    MODSERIAL *serial = q->serial;
    if ( serial->rxGetLastChar() == '\n') {
        newline_detected = true;
    }

}

void txCallback(MODSERIAL_IRQ_INFO *q)
{
    MODSERIAL *serial = q->serial;
    if ( serial->txGetLastChar() == '\0') {
        newline_sent = true;
    }
}

int main()
{
    pc.baud(PC_BAUD);
//    bt.baud(BT_BAUD);
    pc.attach(&rxCallback, MODSERIAL::RxIrq);
//    bt.attach(&txCallback, MODSERIAL::TxIrq);
    
    //set up IMU
    imu.reset();
    imu.setmode(OPERATION_MODE_NDOF);
    setCal();
    imu.get_calib();
    while (imu.calib == 0)
    {
        imu.get_calib();
    }
    
//    char sendData[1] = {0x00};

//    char btData[12] = {'a','b','c','d','e','f','g','\n','\0'};

    while (1) {
        //imu.get_angles();
        //float pitch = imu.euler.pitch;
        //float yaw = imu.euler.yaw;
        //float roll = imu.euler.roll;
        //pc.printf("r:%6.2f p:%6.2f y:%6.2f\n",roll, pitch, yaw);
        imu.get_accel(); //query the i2c device
        pc.printf("x:%6.2f y:%6.2f z:%6.2f\n",imu.accel.x, imu.accel.y, imu.accel.z);
//      
          //pc.printf("about to send data\n");
//        for(int j=0;j<9;j++){
//            btData[j] = '\0';
//            if(bt.writeable())
//                bt.putc(btData[j]);
//            //wait(0.001);
//        }
        wait(0.3);
        //pc.printf("finished sending data\n");
    }
}
