/* mbed LTC2606 1CH 16Bit DAC Library
 * Copyright (c) 2012 Reed Kimble, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef MBED_DACLTC2606_H
#define MBED_DACLTC2606_H

#include "mbed.h"

/* I2C DAC controller class
 */
class DacLtc2606 {
public:
    /** Create a DacLtc2606 object using to the specified I2C object
     *
     * @param i2c The I2C object to communicate with
     */
    DacLtc2606(I2C i2c);
    
    /** Set the DAC output to the specifed unsigned short integer value
     *
     * @param value The 16 bit integer to write (0 to 65535)
     */
    bool write(unsigned short value);
    
    /** Set the DAC output to the specified percentage of max
     *
     * @param percent A double from 0.0 to 1.0 representing the percent of max output power on the DAC
     */
    bool write(double percent);
    
    /** Retreives the unsigned short integer value currently assigned to the DAC output
     */
    unsigned short getCurrentValue();
    
private:
    static const char _slave = 0xE4;
    static const char _command = 0x30;
    I2C _i2c;
    unsigned short _currentValue;
};

#endif