/* Copyright (c) 2012 Reed Kimble, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "DacLtc2606.h"
#include "mbed.h"

DacLtc2606::DacLtc2606(I2C i2c) : _i2c(i2c)
{
    _currentValue = 0;
}

unsigned short DacLtc2606::getCurrentValue()
{
    return _currentValue;
}

bool DacLtc2606::write(unsigned short value)
{
    int opR;
    char args[3];
    args[0] = _command;
    args[1] = (value >> 8) & 0xFF;
    args[2] = value & 0xFF;
    opR = _i2c.write(_slave, args, 3, false);
    if(opR == 0) {_currentValue = value;}
    return (opR == 0) ? true : false;
}

bool DacLtc2606::write(double percent)
{
    if(percent < 0.0) {percent = 0.0;}
    if(percent > 1.0) {percent = 1.0;}
    unsigned short value = 0;
    value = 65535 * percent;
    _currentValue = value;
    return write(value);
}