#include <math.h>
#include "mbed.h"
#include "uLCD_4DGL.h"
#include <time.h>

uLCD_4DGL uLCD(p9, p10,p11);
int operand1;
int operand2;
int op;
int answer;
int ans = 0;
int score = 0;
int seconds = 30;
float seed;
Timer t;
DigitalIn pb1(p13);
DigitalIn pb2(p14);
DigitalIn pb3(p15);
DigitalIn pb4(p16);
DigitalIn pb5(p17);
DigitalIn pb6(p18);


void generateProblem(){
    //generates random numbers between 1 and 40 as operands
    operand1 = rand() % 40 + 1;
    operand2 = rand() % 40 + 1;
    op = rand() % 3;
    
    //genearte random operator and appropriate answer
    if (op == 0){
        uLCD.locate(0,0);
        uLCD.printf("%d + %d\n",operand1, operand2);
        answer = operand1 + operand2;
        }
    else if (op == 1){
        uLCD.locate(0,0);
        uLCD.printf("%d - %d\n",operand1, operand2);
        answer = operand1 - operand2;
        }
    else if (op == 2){
        uLCD.locate(0,0);
        uLCD.printf("%d * %d\n",operand1, operand2);
        answer = operand1 * operand2;        
        }
  
    
    }
int main()
{
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    

    bool randomGen = true;
    t.start();
    while(randomGen){ //push any button to start game
        uLCD.locate(1,0);
        uLCD.printf("Push any button to start the game");
        if(pb1==0 || pb2==0 || pb3==0 || pb4==0 || pb5==0 || pb6 == 0){
            seed = t.read_us();
        randomGen= false;
        t.reset();
        uLCD.cls();
        }
           } 

    
    
    srand((int)seed);
    
    
    
   while(true){
    generateProblem(); //generate problem
    uLCD.locate(1,14);
    uLCD.printf("Score: %d",score);//display score
    t.start();
    
    while(t.read() <= seconds){
           if(seconds - (int)t.read() < 10){ //display time limit
               uLCD.locate(13,1);
               uLCD.printf("%d",(seconds -(int)t.read()));
               } else{
           uLCD.locate(12,1);
           uLCD.printf("%d",(seconds -(int)t.read()));
           }
           //push pushbutton to add up your answer to approach correct answer
       if(pb1 == 0)
        {
        ans = ans + 1;
        uLCD.locate(1,2);
        uLCD.printf("%d",ans);
        wait(0.2);
        }
        else if(pb2 == 0)
        {
        ans = ans + 10;
         uLCD.locate(1,2);
         uLCD.printf("%d",ans);
         wait(0.2);
        }
        else if(pb3 == 0) 
        {
        ans = ans + 100;
         uLCD.locate(1,2);
         uLCD.printf("%d",ans);
         wait(0.2);
        }
        else if(pb4 == 0)
        {
        ans = ans  - 1;
         uLCD.locate(1,2);
         uLCD.printf("%d",ans);
         wait(0.2);
        }
        else if(pb5 == 0) 
        {
        ans = ans - 10;
         uLCD.locate(1,2);
         uLCD.printf("%d",ans);
         wait(0.2);
        }
        else if(pb6 == 0)
        {
        ans = ans - 100;
         uLCD.locate(1,2);
         uLCD.printf("%d",ans);
         wait(0.2);
        }
      }
      
      if( ans == answer){//if correct answer then add score and decrease time limit
        score += 1;
        seconds -=3;
        }else
        {
           uLCD.cls();
           uLCD.printf("You lose!\n Your score is %d",score);
           wait(5);
           score = 0;
           seconds = 30;
        }
        t.reset();
        
      ans = 0;
      
      uLCD.cls();
    
    
    }
    
}
