#include "mbed.h"
#include <string>
#include <ctype.h>
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "PinDetect.h"



PinDetect override(p12);
DigitalOut myled(LED1);
DigitalOut led(LED2);
DigitalOut on(p19);
DigitalOut off(p20);
Serial pc(USBTX, USBRX);
struct tm *cTime;
int cups = 0;
int hour;
int minute;
int timeBrew = 120;



    
void waitForBrew(){
    
    EthernetInterface eth;
    NTPClient ntp;
static const char*          mbedIp       = "128.61.126.186";  //IP
static const char*          mbedMask     = "255.255.240.0";  // Mask
static const char*          mbedGateway  = "128.61.112.1";    //Gateway
    eth.init(mbedIp, mbedMask, mbedGateway); 
    eth.connect();
    ntp.setTime("0.pool.ntp.org");
    time_t currTime = time(NULL);
    
    while(1){
        currTime = time(NULL);
        cTime = localtime(&currTime);
        if (minute == cTime->tm_min && hour == cTime->tm_hour){
            on = 1;
            wait(.5);
            on = 0;
            off =0;
            wait(timeBrew);
            on = 0;
            off = 1;
            wait(.5);
            off = 0;
            }
    }
}

int main() {

on = 0;
off = 1;
override.mode(PullUp);
wait(0.1);
off=0;



    char buffer[20];
    char minBuffer[2];
    char hourBuf[2];
    bool brewing = false;  
     

    

    while(brewing == false){
        if(pc.readable()){
            myled = 0;
            pc.gets(buffer,6);
            wait(0.5);
            pc.printf(buffer);
            pc.printf("\n");
        if(isdigit(buffer[0])){
            led = 1;
                for (int k = 0;k < 2;k++){
                        hourBuf[k] = buffer[k];
                    }
               for(int k =3; k<6; k++){
                        minBuffer[k-3]=buffer[k]; 
                        }         
            hour = atoi(hourBuf);       
            minute = atoi(minBuffer);    
            pc.printf("hour is %d\n",hour);
            pc.printf("minute is %d\n",minute); 
            brewing = true;
           waitForBrew();
            }
        else
            led = 0;
        }
        else
            myled = 1;
        }
      
     
    }  