
#include "mbed.h"
#include "nrf51.h"
#include "nrf51_bitfields.h"
#include <string>

#include "BLE.h"
#include "DFUService.h"
#include "UARTService.h"

#define LED_GREEN   p21
#define LED_RED     p22
#define LED_BLUE    p23
//#define BUTTON_PIN  p17  //used for demux enable
#define BATTERY_PIN p1

#define DEMUX1_1    p3
#define DEMUX1_2    p4
#define DEMUX1_4    p5
#define DEMUX1_8    p6
#define DEMUX1_E0   p17

#define UART_TX     p9
#define UART_RX     p11
#define UART_CTS    p8
#define UART_RTS    p10

//InterruptIn button(BUTTON_PIN);
AnalogIn    battery(BATTERY_PIN);



int read_none_count = 0;

BLEDevice  ble;
UARTService *uartServicePtr;

volatile bool bleIsConnected = false;
volatile uint8_t tick_event = 0;



void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    bleIsConnected = true;
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *cbParams)
{
    ble.startAdvertising();
    bleIsConnected = false;
}

/*void detect(void)
{
    LOG("Button pressed\n");  
    blue = !blue;
}*/

void pins_init(void)
{
      
//how pin init works
// NRF_GPIO - #define NRF_GPIO                        ((NRF_GPIO_Type           *) NRF_GPIO_BASE)
//   NRF_GPIO_Type - struct containing possible settings  (DIR, INPUT, PULL, DRIVE, SENSE, as well as PIN_CNF[] (configuration array for all 32 outputs)
//   NRF_GPIO_BASE - #define NRF_GPIO_BASE                   0x50000000UL  //base register address for GPIO settings
// -> just a way of accessing PIN_CNF[pin_we_want_to_mess_with], object oriented programming stuff
// GPIO_PIN_CNF_SENSE_Disabled   //the appropriate binary value to set sense as disabled
// <<                            //bit shift
// GPIO_PIN_CNF_SENSE_pos        //position that the value of GPIO_PIN_CNF_SENSE_Disabled should be placed at
// | //OR all of these values together to set the register


NRF_GPIO->PIN_CNF[LED_BLUE] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);

NRF_GPIO->PIN_CNF[LED_GREEN] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);
                             
NRF_GPIO->PIN_CNF[LED_RED] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);                            


NRF_GPIO->PIN_CNF[DEMUX1_1] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);    
                             
NRF_GPIO->PIN_CNF[DEMUX1_2] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);    
                             
NRF_GPIO->PIN_CNF[DEMUX1_4] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);   
                             
NRF_GPIO->PIN_CNF[DEMUX1_8] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);    
                             
NRF_GPIO->PIN_CNF[DEMUX1_E0] = (GPIO_PIN_CNF_SENSE_Disabled << GPIO_PIN_CNF_SENSE_Pos)
                             | (GPIO_PIN_CNF_DRIVE_S0S1 << GPIO_PIN_CNF_DRIVE_Pos)
                             | (GPIO_PIN_CNF_PULL_Disabled << GPIO_PIN_CNF_PULL_Pos)
                             | (GPIO_PIN_CNF_INPUT_Disconnect << GPIO_PIN_CNF_INPUT_Pos)
                             | (GPIO_PIN_CNF_DIR_Output << GPIO_PIN_CNF_DIR_Pos);                                                                                                                       
}

    

int main(void)
{
  
    pins_init();
    
    //Turn all LEDs off
    NRF_GPIO->OUTSET = (1UL << LED_BLUE); //remember that writing zeros with outset and outclear has no effect
    NRF_GPIO->OUTSET = (1UL << LED_RED); 
    NRF_GPIO->OUTSET = (1UL << LED_GREEN); 
    
    //All DeMUX inputs to 0 and enable to 1 (disabled)
    NRF_GPIO->OUTCLR = (1UL << DEMUX1_1); 
    NRF_GPIO->OUTCLR = (1UL << DEMUX1_2); 
    NRF_GPIO->OUTCLR = (1UL << DEMUX1_4); 
    NRF_GPIO->OUTCLR = (1UL << DEMUX1_8);
    NRF_GPIO->OUTSET = (1UL << DEMUX1_E0);  
        
    wait(1);
    
    int demux_out = 0xF;
    int increment = 1;
    while (true) {
        NRF_GPIO->OUTCLR = (1UL << DEMUX1_E0)|(0xF << DEMUX1_1);
        NRF_GPIO->OUTSET = (demux_out << DEMUX1_1);

        if(demux_out == 15){increment = -1;}
        else if (demux_out == 9){increment = 1;}
        demux_out = demux_out + increment;
        
        wait(1);
    }
}


