#include "System.h"

ByteQueue PCBackDoorTx,PCBackDoorRx;
BYTE PCBackDoorTx_Queue_Storage[PC_BACKDOOR_TX_QUEUE_SIZE];
BYTE PCBackDoorRx_Queue_Storage[PC_BACKDOOR_RX_QUEUE_SIZE];

Serial PCBackDoor(USBTX, USBRX); 
Ticker PCBackDoorTxQueueCheck;

//IRQ for when data is received
void PCBackDoorRxIRQ();
void PCBackDoorMoveTxQueue();

void InitPCBackDoor()
{
    InitByteQueue(&PCBackDoorTx,PC_BACKDOOR_TX_QUEUE_SIZE,&PCBackDoorTx_Queue_Storage[0]);
    InitByteQueue(&PCBackDoorRx,PC_BACKDOOR_RX_QUEUE_SIZE,&PCBackDoorRx_Queue_Storage[0]);
    
    PCBackDoor.baud(9600);
    PCBackDoor.format(8,Serial::None,1);  
 
    
    //The Rx IRQ wil fill up my big software Rx Queue
    PCBackDoor.attach(&PCBackDoorRxIRQ);
    
    //Periodicically check my outgoing Tx Queue (every 1 mS)
   PCBackDoorTxQueueCheck.attach_us(&PCBackDoorMoveTxQueue,500);
}

void PCBackDoorMoveTxQueue()
{
    BYTE Temp;
    
    while(PCBackDoor.writeable())
    {
        if(BytesInQueue(&PCBackDoorTx) == 0)
        {
            break;
        }
        else
        {
            ByteDequeue(&PCBackDoorTx,&Temp);
            PCBackDoor.putc(Temp);
        }
    }
 
}

void PCBackDoorRxIRQ()
{
   while(PCBackDoor.readable())
    {
         ByteEnqueue(&PCBackDoorRx,(BYTE)PCBackDoor.getc());   
    }
}

