#include "DataTypes.h"
#include "FixedMath.h"

#define _INLINE_GFX_GET_PIXEL
#define _INLINE_GFX_PUT_PIXEL


#ifndef _GFX_H
#define _GFX_H



typedef struct 
{
    SIGNED_WORD X;
    SIGNED_WORD Y;    
} GFXDisplayPoint;


typedef struct 
{
    BitPlane RenderPlane;
    WORD SizeX;
    WORD SizeY;
    
} RenderContext;


typedef struct 
{
    GFXDisplayPoint P1;
    GFXDisplayPoint P2;    
} GFXDisplayBox;


typedef struct 
{
    BYTE FontWidth;
    BYTE FontHeight;
    BYTE BytesPerColumn;
    BYTE *FontBuffer;    
    BYTE *CharacterWidthTable;

} GFXFont;

typedef struct
    {
        SIGNED_WORD X;
        SIGNED_WORD Y;
    } GFXRelativePoint;

typedef struct 
    {
            GFXDisplayPoint Center;
            BYTE NumPoints;
            BYTE DrawMode;
            GFXRelativePoint *PointList;
    } GFXListPrimitive;


#define GFX_LIST_PRIMITIVE_CONNECTED        0x01
#define GFX_LIST_PRIMITIVE_DISCONNECTED        0x02
#define GFX_LIST_PRIMITIVE_CLOSED            0x03

#define GFX_LIST_PRIMITIVE_CONNECTED_YFLIPPED            0x04
#define GFX_LIST_PRIMITIVE_DISCONNECTED_YFLIPPED        0x05
#define GFX_LIST_PRIMITIVE_CLOSED_YFLIPPED                0x06

#define BICOLOR_BLACK    0
#define BICOLOR_RED        0x1    
#define BICOLOR_GREEN    0x2
#define BICOLOR_YELLOW    0x3

#define GFX_MAX_STRING_LEN 32

//System/Hardware specific stuff
void GFX_InitPhysicalScreen();
void GFX_DumpRenderContextToPhysicalScreen(RenderContext *Image);
void GFX_Init();
void GFX_PowerUpScreen();
void GFX_PowerDownScreen();

//Device indepedent Functions
void GFX_FullDisplayBufferClear(RenderContext *Image);
void GFX_PutPixel(RenderContext *Image, SIGNED_WORD x, SIGNED_WORD y);
void GFX_DrawHline(RenderContext *Image, SIGNED_WORD XStart, SIGNED_WORD XStop, SIGNED_WORD Y);
void GFX_DrawVline(RenderContext *Image, SIGNED_WORD YStart, SIGNED_WORD YStop, SIGNED_WORD X);
void GFX_DrawLine(RenderContext *Image, SIGNED_WORD X1,SIGNED_WORD Y1, SIGNED_WORD X2,SIGNED_WORD Y2);
void GFX_DrawBox(RenderContext *Image, GFXDisplayBox *Box);
SIGNED_WORD GFX_DrawCharacter(RenderContext *Image, BYTE Character, SIGNED_WORD StartX, SIGNED_WORD StartY, GFXFont *MyFont);
SIGNED_WORD GFX_GetStringWidth(CHAR * String,GFXFont * MyFont);
void GFX_DrawString(RenderContext * Image,CHAR * String,SIGNED_WORD StartX, SIGNED_WORD StartY, GFXFont * MyFont);
void  GFX_printf(RenderContext * Image,SIGNED_WORD StartX, SIGNED_WORD StartY, GFXFont * MyFont, const char *FormatString,...);
void GFX_DrawCenteredString(RenderContext * Image,CHAR * String,SIGNED_WORD StartX, SIGNED_WORD StartY, GFXFont * MyFont);
void GFX_DrawListPrimitive(RenderContext * Image,GFXListPrimitive *LP);
void GFX_DrawScaledListPrimitive(RenderContext * Image,GFXListPrimitive *LP , FIXED_7_8 Scale);
void GFX_DrawRotatedListPrimitive(RenderContext * Image,GFXListPrimitive *LP , BYTE Angle);
//void GFX_AddRotatedListPrimitive(RenderContext * Image,GFXListPrimitive *LP , BYTE Angle);
//void GFX_DrawScaledRotatedListPrimitive(RenderContext * Image,GFXListPrimitive *LP , BYTE Angle,GFXFixed_7_8 Scale);



#ifdef _INLINE_GFX_GET_PIXEL
inline BYTE GFX_GetPixel(RenderContext *Image, SIGNED_WORD x, SIGNED_WORD y)
{
    BYTE PixelColor = 0;
    
    if((x<Image->SizeX) && (y<Image->SizeY) && (x>=0) && (y>=0))
    {
        
        if(BitPlane_Get(&Image->RenderPlane,x,y))
            PixelColor = TRUE;

    }
    
    return PixelColor;
}
#else
    BYTE GFX_GetPixel(RenderContext *Image, SIGNED_WORD x, SIGNED_WORD y);
#endif


extern RenderContext BackBuffer;
extern GFXFont Font5x7;
extern GFXFont Font3x5;


#define BACK_BUFFER_SIZE_X    (64)
#define BACK_BUFFER_SIZE_Y  (32)

#define PHYSICAL_DISPLAY_XRES                (BYTE)(64)
#define PHYSICAL_DISPLAY_YRES                (BYTE)(32)
#define DISPLAY_X_WIDTH_BYTE                (PHYSICAL_DISPLAY_XRES>>3)
#define DISPLAY_BUFFER_TOTAL_SIZE             (DISPLAY_X_WIDTH_BYTE*PHYSICAL_DISPLAY_YRES*2)
#define GREEN_DATA_BUFFER_OFFSET              (DISPLAY_X_WIDTH_BYTE * PHYSICAL_DISPLAY_YRES)
#define PHYSICAL_DISPLAY_X_WIDTH_IN_BYTES   (PHYSICAL_DISPLAY_XRES>>3)
#define PHYSICAL_DISPLAY_PLANE_BUFFER_SIZE  (PHYSICAL_DISPLAY_X_WIDTH_IN_BYTES * PHYSICAL_DISPLAY_YRES)
#define PHYSICAL_DISPLAY_BUFFER_TOTAL_SIZE  (PHYSICAL_DISPLAY_X_WIDTH_IN_BYTES * PHYSICAL_DISPLAY_YRES*2)


#endif




