#include "System.h"


//*****************************************************************
//Terminal Related stuff
//*****************************************************************

#define MAX_TERMINAL_LINE_CHARS 128
#define MAX_TERMINAL_CMD_CHARS 32
CHAR TerminalLineBuf[MAX_TERMINAL_LINE_CHARS];
BYTE TerminalPos;
CHAR TerminalCmdBuf[MAX_TERMINAL_CMD_CHARS+1];
CHAR TerminalArgs[MAX_TERMINAL_LINE_CHARS-MAX_TERMINAL_CMD_CHARS];
BYTE NextCharIn;
BOOL CmdFound;


 
#define NUM_TERMINAL_CMDS    9

char *TerminalCommands[NUM_TERMINAL_CMDS] = {"help","reboot","v","i","Time","Date","RTC_Init","Batt",">>>"};

typedef void (*TerminalCallback)(char *);


void TerminalCmd_Help(char *arg);
void TerminalCmd_Reboot(char *arg);
void TerminalCmd_v(char *arg);
void TerminalCmd_i(char *arg);
void TerminalCmd_Time(char *arg);
void TerminalCmd_Date(char *arg);
void TerminalCmd_RTC_Init(char *arg);
void TerminalCmd_Batt(char *arg);
void TerminalCmd_NormalMode(char *arg);


TerminalCallback TerminalCallbacks[NUM_TERMINAL_CMDS] ={TerminalCmd_Help};


void InitTerminal()
{
    //Initialize the terminal command callbacks
    TerminalCallbacks[0] = TerminalCmd_Help;
    TerminalCallbacks[1] = TerminalCmd_Reboot;
    TerminalCallbacks[2] = TerminalCmd_v;
    TerminalCallbacks[3] = TerminalCmd_i;
    TerminalCallbacks[4] = TerminalCmd_Time;
    TerminalCallbacks[5] = TerminalCmd_Date;
    TerminalCallbacks[6] = TerminalCmd_RTC_Init;
    TerminalCallbacks[7] = TerminalCmd_Batt;
    TerminalCallbacks[8] = TerminalCmd_NormalMode;

}


extern "C" void mbed_reset();


void TerminalCmd_Batt(char *)
{
   PrintfEnqueue(&PCBackDoorTx,"\r\nBattery: %.3f\r\n",BatteryVoltage);
}
void TerminalCmd_RTC_Init(char *arg)
{
   set_time(1256729737);
   PrintfEnqueue(&PCBackDoorTx,"\r\nTime Reset\r\n");
}


void TerminalCmd_Time(char *arg)
{      
 int Hour,Minute,Second=0;
    int Items;
    BOOL Error = FALSE;
    time_t TimeStampTemp;
    
    
    Items = sscanf(arg, "%d : %d  : %d", &Hour, &Minute, &Second);
    if(Items == 3)
    {
        PrintfEnqueue(&PCBackDoorTx,"\r\n");
        if(Hour>23)
        {
            PrintfEnqueue(&PCBackDoorTx,"Hour entry must be between 0 and 24\r\n");
            Error = TRUE;
        }
        if(Minute>60)
        {
            PrintfEnqueue(&PCBackDoorTx,"Minute entry must be between 0 and 60\r\n");
            Error = TRUE;
        }
        if(Second>60)
        {
            PrintfEnqueue(&PCBackDoorTx,"Second entry must be between 0 and 60\r\n");
            Error = TRUE;
        }
        
        if(Error == TRUE)
        {
         PrintfEnqueue(&PCBackDoorTx,"Error in time format.  Time syntax should be  H:M:S\r\n. Time not changed.\r\n");
        }
        else
        {
            TimeStampTemp = time(NULL);
            //convert to tm struct 
            CurrentTime = localtime(&TimeStampTemp);
            //dump in our new valus
            CurrentTime->tm_sec = Second;
            CurrentTime->tm_min = Minute;
            CurrentTime->tm_hour = Hour;
            //set the new time
            set_time(mktime(CurrentTime));
            PrintfEnqueue(&PCBackDoorTx,"Time set to %d:%d:%d\r\n",Hour,Minute,Second);
        }
     
      }      
      else
      {
             PrintfEnqueue(&PCBackDoorTx,"Time syntax should be  H:M:S\r\n");
      } 
}

void TerminalCmd_Date(char *arg)
{      
 int Day,Month,Year=0;
    int Items;
    BOOL Error = FALSE;
    time_t TimeStampTemp;
    
    Items = sscanf(arg, "%d / %d  / %d", &Month, &Day, &Year);
    if(Items == 3)
    {
        PrintfEnqueue(&PCBackDoorTx,"\r\n");
        if(Month>12 || Month < 1)
        {
            PrintfEnqueue(&PCBackDoorTx,"\r\nMonth entry must be between 1 and 12\r\n");
            Error = TRUE;
        }
        if(Day>31 || Day<1)
        {
            PrintfEnqueue(&PCBackDoorTx,"\r\nDay entry must be between 1 and 31\r\n");
            Error = TRUE;
        }
        if(Year<1900)
        {
            PrintfEnqueue(&PCBackDoorTx,"\r\nYear entry must be greater than 1900\r\n");
            Error = TRUE;
        }
        
        if(Error == TRUE)
        {
         PrintfEnqueue(&PCBackDoorTx,"\r\nError in Date format.  Date not changed.\r\n");
        }
        else
        {
            //Get the current time in seconds since unix epoch
            TimeStampTemp = time(NULL);
            //convert to tm struct fom
            CurrentTime = localtime(&TimeStampTemp);
            //dump in our new valus
            CurrentTime->tm_mon = Month-1;
            CurrentTime->tm_mday = Day;
            CurrentTime->tm_year = Year - 1900;
            //set the new time
            set_time(mktime(CurrentTime));
            PrintfEnqueue(&PCBackDoorTx,"\r\nDate set to %d/%d/%d\r\n",Month,Day,Year);
        }
     
      }    
      else
      {
             PrintfEnqueue(&PCBackDoorTx,"Date syntax should be  MM/DD/YYYY\r\n");
      } 
}

void TerminalCmd_v(char *arg)
{
   //   PrintfEnqueue(&PCBackDoorTx,"\r\nVbus: %.1f\r\n",Vout);
}

void TerminalCmd_i(char *arg)
{
//      PrintfEnqueue(&PCBackDoorTx,"\r\nIbus: %.1f\r\n",Iout);
}

void TerminalCmd_Help(char *arg)
{
    BYTE i;

      PrintfEnqueue(&PCBackDoorTx,"\r\n\r\bCommandList:\r\n");
      PrintfEnqueue(&PCBackDoorTx,"----------------------\r\n");

    for(i=0;i<NUM_TERMINAL_CMDS;i++)
    {
         PrintfEnqueue(&PCBackDoorTx,"%s\r\n",TerminalCommands[i]);    
    }

}
void TerminalCmd_NormalMode(char *arg){
    PrintfLogEnqueue(&PCBackDoorTx,"Exiting Normal mode\r\n >");
    WeAreInNormalMode=FALSE;
}
void TerminalCmd_Reboot(char *arg)
{
       mbed_reset();
}

void TerminalCmd_Strip(char *arg)
{
        PrintfEnqueue(&PCBackDoorTx,"\r\n%s\r\n", arg);
}
BYTE AngleCount=0;

void ProcessTerminal()
{

      BYTE i,j;
    if(BytesInQueue(&PCBackDoorRx)>0)
    {
        ByteDequeue(&PCBackDoorRx,&NextCharIn);
        if(WeAreInNormalMode){
            switch(NextCharIn)
            {
                case '\r':
                 TerminalLineBuf[TerminalPos++] = 0x0;
                 ByteEnqueue(&PCBackDoorTx,NextCharIn);
                
                 if(TerminalPos > 1)
                 {
                     //find the command
                     i=0;
                     while(TerminalLineBuf[i]>0x20 &&  TerminalLineBuf[i]<0x7f)
                     {
                          TerminalCmdBuf[i] = TerminalLineBuf[i];
                          i++;
        
                        if(i==MAX_TERMINAL_CMD_CHARS)
                            {
                             break;
                            }
                     }
                        
                    TerminalCmdBuf[i] = 0;
                    TerminalCmdBuf[i+1] = 0;
                
                    strcpy(TerminalArgs,&TerminalLineBuf[i]);
    
                    CmdFound = FALSE;
                    for(j=0;j<NUM_TERMINAL_CMDS;j++)
                    {           
                        if(strcmp(TerminalCmdBuf,TerminalCommands[j]) == 0)
                        {
                            if(TerminalCallbacks[j] != NULL)
                                TerminalCallbacks[j](TerminalArgs);
                        
                            CmdFound = TRUE;
                            break;
                        }             
                    }        
                    if(CmdFound == FALSE)
                    {
                       PrintfEnqueue(&PCBackDoorTx,"%s command not recognized.\r\n", TerminalCmdBuf);
                    }
                  }    
                 ByteEnqueue(&PCBackDoorTx,'\n');
                 ByteEnqueue(&PCBackDoorTx,'>');
                 TerminalPos = 0;
                
                break;
                case '\b':
                    if(TerminalPos > 0)
                    {
                        TerminalPos--;    
                        ByteEnqueue(&PCBackDoorTx,NextCharIn);
                    }
                break;
                
                default:
                    
                    if(TerminalPos == 0 && NextCharIn == 0x020)
                    {
                         //Do nothing if space bar is pressed at begining of line    
                    }
                       else if(NextCharIn >= 0x20 && NextCharIn<0x7F)
                    {
                        
                        if(TerminalPos < MAX_TERMINAL_LINE_CHARS-1)
                        {
                             TerminalLineBuf[TerminalPos++] = NextCharIn;
                               ByteEnqueue(&PCBackDoorTx,NextCharIn);
                        }
                    }
                
                break;
            
            }//end of character switch
        }else{  //not normal mode
            switch(NextCharIn){
                case '>':
                    AngleCount++;
                    if(AngleCount > 2){
                        WeAreInNormalMode=TRUE;
                        PrintfLogEnqueue(&PCBackDoorTx,"Entering Normal mode\r\n >");
                        AngleCount=0;
                    }
                    break; 
            }                                
        }
    }
 }
void LogSerial(){
    UINT t;
    UINT BytesWritten;
    if(BytesInQueue(&PCBackDoorRx)>0)
    {
        ByteDequeue(&PCBackDoorRx,&NextCharIn);
          switch(NextCharIn){
            case '>':
                AngleCount++;
                if(AngleCount > 2){
                    WeAreInNormalMode=TRUE;
                    PrintfLogEnqueue(&PCBackDoorTx,"Entering Normal mode\r\n >");
                }
                break;
            case '\n':
                break; //just eat
            case '\r':
                 SerialLineBuffer[SerialLineBufferPtr++]='\r';
                 SerialLineBuffer[SerialLineBufferPtr++]='\n';
                if(SystemState == SYSTEM_STATE_SERIAL_LOGGING){
                    if(f_write(&CurrentLogFileHandle,SerialLineBuffer,SerialLineBufferPtr,&BytesWritten)){ //if we didn't work kick out
                        PrintfLogEnqueue(&PCBackDoorTx,"QQQ\r\n");  //Shutdown
                        PrintfEnqueue(&PCBackDoorTx,"Failed to write\r\n");
                        EnterSystemState(SYSTEM_STATE_IDLE);
                    }else{
                        if(BytesWritten != 0){
                           LinesWritten++;
                            if(LinesWritten > NUMBEROFLINESBEFORESYNC){
                                f_sync(&CurrentLogFileHandle);
                                PrintfEnqueue(&PCBackDoorTx,"Synced");
                                LinesWritten=0;
                            }
                        }
                    }
                }
                SerialLineBufferPtr=0; //Always do this so we don't overflow
                SerialCount++;
                if(SerialCount > 5000)SerialCount=0;
                break;
            default:
                AngleCount=0;
                SerialLineBuffer[SerialLineBufferPtr++]=NextCharIn;
                if(SerialLineBufferPtr > 255){
                    if(SystemState == SYSTEM_STATE_SERIAL_LOGGING){
                        if(f_write(&CurrentLogFileHandle,SerialLineBuffer,SerialLineBufferPtr,&BytesWritten)){ //if we didn't work kick out
                            PrintfLogEnqueue(&PCBackDoorTx,"QQQ\r\n");  //Shutdown
                            PrintfEnqueue(&PCBackDoorTx,"Failed to write default\r\n");
                            EnterSystemState(SYSTEM_STATE_IDLE);
                        }
                    }
                    SerialLineBufferPtr=0;
                }
                break;
        }// end of non-normal switch
    }//for commit
}

