#include "System.h"

LocalFileSystem LocalFS("local"); 

CHAR LineBuf[128];

//Voltage Divider for the Li_poly Battery
float R17,R15;
#define R17_DEFAULT  (float)(10000.0)
#define R15_DEFAULT  (float)(10000.0)

//Voltage Divider for input voltage measurement
float R2,R4;
#define R2_DEFAULT  (float)(100000.0)
#define R4_DEFAULT  (float)(3300.0)

//Voltage Divider for current voltage measurement (to the 16-bit ADC)
float R6,R7;
#define R6_DEFAULT (float) (10000.0)
#define R7_DEFAULT  (float)(10000.0)

//Voltage Divider for current voltage measurement (to the 12-bit ADC)
float R8,R9;
#define R8_DEFAULT  (float)(5100.0)
#define R9_DEFAULT  (float)(10000.0)

//value of the 2.5Voltage reference
float U1_VREF;
#define U1_VREF_DEFAULT    (float)(2.5)

//value of the MBED Voltage reference
float MBED_VREF;
#define MBED_VREF_DEFAULT    (float)(3.3)

//value of the input diode drop
float INPUT_DIODE_DROP;
#define INPUT_DIODE_DROP_DEFAULT   (float)(0.601)


//used for self current 
float R22;
#define R22_DEFAULT 0.5

float R18;
#define R18_DEFAULT 200

float R19;
#define R19_DEFAULT 200

float R20;
#define R20_DEFAULT 10000


//Parameters for the ACS576 Current Sensor

float ACS576_VOFFSET;
#define ACS576_VOFFSET_DEFAULT              (2.5)

float ACS576_ISCALE; 
#define ACS576_ISCALE_DEFAULT              (25.0)

float ACS576_ISCALE_ADJUST; 
#define ACS576_ISCALE_ADJUST_DEFAULT         (1.0)

float ACS576_IOFFSET_TRIM; 
#define ACS576_IOFFSET_TRIM_DEFAULT        (0.0)

//Used to correct the input voltage measurement
float  VSCALE_ADJUST; 
#define VSCALE_ADJUST_DEFAULT        (1.0)

float  VOFFSET_ADJUST; 
#define VOFFSET_ADJUST_DEFAULT        (0.0)

//Sampling Parameters
float   SAMPLE_RATE;
DWORD   WRITE_BLOCK_THRESH;

CHAR SERIALSPEED;
#define SERIALSPEED_DEFAULT '2'
CHAR ID[MAX_ID_LENGTH+1];
#define ID_DEFAULT "No ID"

void LoadDefaults()
{
    strcpy(ID,ID_DEFAULT);

    VOFFSET_ADJUST = VOFFSET_ADJUST_DEFAULT;
    VSCALE_ADJUST  = VSCALE_ADJUST_DEFAULT;
    
    R17 = R17_DEFAULT;
    R15 = R15_DEFAULT;

    R2 = R2_DEFAULT;
    R4 = R4_DEFAULT;

    R6 = R6_DEFAULT;
    R7 = R7_DEFAULT;
    
    R8 = R8_DEFAULT;
    R9 = R9_DEFAULT;
    
    R18 = R18_DEFAULT;
    R19 = R19_DEFAULT;
    R20 = R20_DEFAULT;
    R22 = R22_DEFAULT;
    
    U1_VREF = U1_VREF_DEFAULT;
    MBED_VREF = MBED_VREF_DEFAULT;
    
    INPUT_DIODE_DROP =  INPUT_DIODE_DROP_DEFAULT;
    
    ACS576_VOFFSET = ACS576_VOFFSET_DEFAULT;

    ACS576_ISCALE =  ACS576_ISCALE_DEFAULT;
    ACS576_ISCALE_ADJUST = ACS576_ISCALE_ADJUST_DEFAULT;
    
    ACS576_IOFFSET_TRIM = ACS576_IOFFSET_TRIM_DEFAULT;
    
    SAMPLE_RATE = SAMPLE_RATE_DEFAULT;
    WRITE_BLOCK_THRESH = WRITE_BLOCK_THRESH_DEFAULT;
    SERIALSPEED=SERIALSPEED_DEFAULT;
}

void ExportConfigurationSettings()
{
    FILE *MyConfigFile = fopen("/local/config.txt","w");
    
    
    fprintf(MyConfigFile,"ACS576_ISCALE_ADJUST = %.3f  \r\n",ACS576_ISCALE_ADJUST); 
    fprintf(MyConfigFile,"ACS576_IOFFSET_TRIM = %.3f  \r\n",ACS576_IOFFSET_TRIM);
    
    fprintf(MyConfigFile,"VSCALE_ADJUST = %.3f  \r\n",VSCALE_ADJUST);
    fprintf(MyConfigFile,"VOFFSET_ADJUST = %.3f  \r\n",VOFFSET_ADJUST);
    
    fprintf(MyConfigFile,"R17 = %.1f  \r\n",R17);
    fprintf(MyConfigFile,"R15 = %.1f  \r\n",R15);

    fprintf(MyConfigFile,"R2 = %.1f  \r\n",R2);
    fprintf(MyConfigFile,"R4 = %.1f  \r\n", R4);

    fprintf(MyConfigFile,"R6 = %.1f  \r\n",R6);
    fprintf(MyConfigFile,"R7 = %.1f  \r\n",R7);
    
    fprintf(MyConfigFile,"R8 = %.1f  \r\n",R8);
    fprintf(MyConfigFile,"R9 = %.1f  \r\n",R9);
    
    fprintf(MyConfigFile,"R18 = %.1f  \r\n",R18);
    fprintf(MyConfigFile,"R19 = %.1f  \r\n",R19);
    fprintf(MyConfigFile,"R20 = %.1f  \r\n",R20);
    fprintf(MyConfigFile,"R22 = %.1f  \r\n",R22);
    
    fprintf(MyConfigFile,"U1_VREF = %.3f  \r\n",U1_VREF);
    fprintf(MyConfigFile,"MBED_VREF = %.3f  \r\n",MBED_VREF);
    
    fprintf(MyConfigFile,"INPUT_DIODE_DROP = %.3f  \r\n",INPUT_DIODE_DROP);
    
    fprintf(MyConfigFile,"ACS576_VOFFSET = %.3f  \r\n",ACS576_VOFFSET);

    fprintf(MyConfigFile,"ACS576_ISCALE = %.3f  \r\n", ACS576_ISCALE_DEFAULT);
   
    
    fprintf(MyConfigFile,"SAMPLE_RATE = %.1f  \r\n",SAMPLE_RATE);
    fprintf(MyConfigFile,"WRITE_BLOCK_THRESH = %d  \r\n",WRITE_BLOCK_THRESH);
  
    fprintf(MyConfigFile,"ID = %s    \r\n",ID);
  
    fprintf(MyConfigFile,"SERIAL_SPEED = %c",SERIALSPEED);
    
    fclose(MyConfigFile);
}

//This is a very "static implementation.  Just does string compares.  Would be nice to have a table like feature in the future
void  ParseKeyValue(const CHAR *Key,const CHAR *Value)
{
    WORD i;
    
     if(!strcmp(Key,(CHAR *)"R17"))
    {
        R17 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R17 assigned a value of %.3f",R17);
    }
    else if(!strcmp(Key,"R15"))
    {
        R15 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R15 assigned a value of %.3f",R15);
    }
    else if(!strcmp(Key,"R2"))
    {
        R2 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R2 assigned a value of %.3f",R2);
    }
    else if(!strcmp(Key,"R4"))
    {
        R4 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R4 assigned a value of %.3f",R4);
    }
    else if(!strcmp(Key,"R6"))
    {
        R6 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R6 assigned a value of %.3f",R6);
    }
    else if(!strcmp(Key,"R7"))
    {
        R7 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R7 assigned a value of %.3f",R7);
    }
    else if(!strcmp(Key,"R8"))
    {
        R8 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R8 assigned a value of %.3f",R8);
    }
    else if(!strcmp(Key,"R9"))
    {
        R9 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R9 assigned a value of %.3f",R9);
    }
    else if(!strcmp(Key,"U1_VREF"))
    {
        U1_VREF = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"U1_VREF assigned a value of %.3f",U1_VREF);
    }
    else if(!strcmp(Key,"MBED_VREF"))
    {
        MBED_VREF = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"MBED_VREF assigned a value of %.3f",MBED_VREF);
    }
    else if(!strcmp(Key,"INPUT_DIODE_DROP"))
    {
        INPUT_DIODE_DROP = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"INPUT_DIODE_DROP assigned a value of %.3f",INPUT_DIODE_DROP);
    }
    else if(!strcmp(Key,"ACS576_VOFFSET"))
    {
        ACS576_VOFFSET = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"ACS576_VOFFSET assigned a value of %.3f", ACS576_VOFFSET);
    }
    else if(!strcmp(Key,"ACS576_ISCALE"))
    {
        ACS576_ISCALE = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"ACS576_ISCALE assigned a value of %.3f", ACS576_ISCALE);
    }
     else if(!strcmp(Key,"ACS576_ISCALE_ADJUST"))
    {
        ACS576_ISCALE_ADJUST = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"ACS576_ISCALE_ADJUST assigned a value of %.3f", ACS576_ISCALE_ADJUST);
    }
    else if(!strcmp(Key,"ACS576_IOFFSET_TRIM"))
    {
        ACS576_IOFFSET_TRIM = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"ACS576_IOFFSET_TRIM assigned a value of %.3f",  ACS576_IOFFSET_TRIM);
    }
    else if(!strcmp(Key,"R18"))
    {
        R18 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R18 assigned a value of %.3f",  R18);
    }
    else if(!strcmp(Key,"R19"))
    {
        R19 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R19 assigned a value of %.3f",  R19);
    }
    else if(!strcmp(Key,"R20"))
    {
        R20 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R20 assigned a value of %.3f",  R20);
    }
    else if(!strcmp(Key,"R22"))
    {
        R22 = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"R22 assigned a value of %.3f",  R22);
    }
    else if(!strcmp(Key,"VSCALE_ADJUST"))
    {
        VSCALE_ADJUST = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"VSCALE_ADJUST assigned a value of %.3f",  VSCALE_ADJUST);
    }
    else if(!strcmp(Key,"VOFFSET_ADJUST"))
    {
        VOFFSET_ADJUST = atof(Value);
        PrintfEnqueue(&PCBackDoorTx,"VOFFSET_ADJUST assigned a value of %.3f",  VOFFSET_ADJUST);
    }
    else if(!strcmp(Key,"SAMPLE_RATE"))
    {
        SAMPLE_RATE = atof(Value);
         
           if(SAMPLE_RATE < MIN_SAMPLE_RATE || SAMPLE_RATE > MAX_SAMPLE_RATE)
           {
               PrintfEnqueue(&PCBackDoorTx,"Illegal SAMPLE_RATE of %.1f was specified. %.1f is being used",SAMPLE_RATE,SAMPLE_RATE_DEFAULT);
                SAMPLE_RATE = SAMPLE_RATE_DEFAULT;
            }
            else
            {
                    PrintfEnqueue(&PCBackDoorTx,"SAMPLE_RATE assigned a value of %.1f",  SAMPLE_RATE);
            }
    }
    
    else if(!strcmp(Key,"WRITE_BLOCK_THRESH"))
    {
         WRITE_BLOCK_THRESH = (DWORD)atof(Value);
         
           if(WRITE_BLOCK_THRESH < MIN_WRITE_BLOCK_THRESH|| WRITE_BLOCK_THRESH > MAX_WRITE_BLOCK_THRESH)
           {
                PrintfEnqueue(&PCBackDoorTx,"Illegal WRITE_BLOCK_THRESH of %d was specified. %d is being used\r\n",WRITE_BLOCK_THRESH,WRITE_BLOCK_THRESH_DEFAULT);
                PrintfEnqueue(&PCBackDoorTx,"WRITE_BLOCK_THRESH must be between %d and %d",MIN_WRITE_BLOCK_THRESH, MAX_WRITE_BLOCK_THRESH); 
             
                WRITE_BLOCK_THRESH = WRITE_BLOCK_THRESH_DEFAULT;
            }
            else
            {
                    PrintfEnqueue(&PCBackDoorTx,"WRITE_BLOCK_THRESH assigned a value of %d",  WRITE_BLOCK_THRESH);
            }
    }
    else if(!strcmp(Key,"SERIAL_SPEED")){
        SERIALSPEED=*Value;
        PrintfEnqueue(&PCBackDoorTx,"Serial Speed assigned a value of %c \r\n",SERIALSPEED);
    }
        
    else if(!strcmp(Key,"ID"))
    {
        if(strlen(Value)>MAX_ID_LENGTH)
        {
             PrintfEnqueue(&PCBackDoorTx,"ID must be %d characters or less.  Truncating...",  MAX_ID_LENGTH); 
             for(i=0;i<MAX_ID_LENGTH;i++)
             {
                ID[i] = Value[i];
                ID[MAX_ID_LENGTH] = NULL;
             }         
        } 
        else
        {
          strcpy(ID,Value);
        }     
      
        PrintfEnqueue(&PCBackDoorTx,"ID assigned a value of %s",  ID);  
    }
    else
    {
        PrintfEnqueue(&PCBackDoorTx,"%s key is not recognized parameter",Key);
    }
   
    PrintfEnqueue(&PCBackDoorTx,"\r\n");

}

void LoadConfiguration()
{
    WORD CurrentLine = 1;
    
    LoadDefaults();

    SmartSwitch_SetBackLightColor(3,3,3);
    GFX_FullDisplayBufferClear(&BackBuffer);
    GFX_DrawString(&BackBuffer,"Loading Config",0,0,&Font3x5);
    GFX_DumpRenderContextToPhysicalScreen(&BackBuffer);
    
    FILE *MyConfigFile = fopen("/local/config.txt","r");
    
    if(!MyConfigFile)
    {
        PrintfEnqueue(&PCBackDoorTx,"Could not open configuration files. Using Defaults....\r\n");
        wait(1);
        return;
    }
    
    PrintfEnqueue(&PCBackDoorTx,"Config file found.  Parsing.....\r\n\r\n");
  
    while(fgets(LineBuf,sizeof(LineBuf),MyConfigFile))
    {
       if(KeyValueSplit(LineBuf,Key,Value))
       {
             ParseKeyValue(Key,Value);
       }
       else
       {
           PrintfEnqueue(&PCBackDoorTx,"No valid key=value pair on line %d\r\n",CurrentLine);
       }
       
       CurrentLine++;
    }
    
    fclose(MyConfigFile);
    
    PrintfEnqueue(&PCBackDoorTx,"\r\n\r\n>");
}



