/*
    FreeRTOS V6.0.3 - Copyright (C) 2010 Real Time Engineers Ltd.

    ***************************************************************************
    *                                                                         *
    * If you are:                                                             *
    *                                                                         *
    *    + New to FreeRTOS,                                                   *
    *    + Wanting to learn FreeRTOS or multitasking in general quickly       *
    *    + Looking for basic training,                                        *
    *    + Wanting to improve your FreeRTOS skills and productivity           *
    *                                                                         *
    * then take a look at the FreeRTOS eBook                                  *
    *                                                                         *
    *        "Using the FreeRTOS Real Time Kernel - a Practical Guide"        *
    *                  http://www.FreeRTOS.org/Documentation                  *
    *                                                                         *
    * A pdf reference manual is also available.  Both are usually delivered   *
    * to your inbox within 20 minutes to two hours when purchased between 8am *
    * and 8pm GMT (although please allow up to 24 hours in case of            *
    * exceptional circumstances).  Thank you for your support!                *
    *                                                                         *
    ***************************************************************************

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation AND MODIFIED BY the FreeRTOS exception.
    ***NOTE*** The exception to the GPL is included to allow you to distribute
    a combined work that includes FreeRTOS without being obliged to provide the
    source code for proprietary components outside of the FreeRTOS kernel.
    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details. You should have received a copy of the GNU General Public 
    License and the FreeRTOS license exception along with FreeRTOS; if not it 
    can be viewed here: http://www.freertos.org/a00114.html and also obtained 
    by writing to Richard Barry, contact details for whom are available on the
    FreeRTOS WEB site.

    1 tab == 4 spaces!

    http://www.FreeRTOS.org - Documentation, latest information, license and
    contact details.

    http://www.SafeRTOS.com - A version that is certified for use in safety
    critical systems.

    http://www.OpenRTOS.com - Commercial support, development, porting,
    licensing and training services.
*/

/*
 *  Modified for mbed NXP LPC1768 board
 *  By Kenji Arai / JH1PJL on March 13th,2010
 *         April 12th, 2010    Changed LPC17xx.h then convert all "GPIO" to "LPC_GPIO"
 *         August 1st, 2010    Change Port definition
 *         August 28th, 2010
 */


/* FreeRTOS.org includes. */
#include "FreeRTOS.h"

/* Demo application includes. */
#include "partest.h"

/*-----------------------------------------------------------
 * Simple parallel port IO routines.
 *-----------------------------------------------------------*/
#if (USE_XPRESSO == 1)
void vParTestInitialise( void )
{
    /* LEDs on port 1. */
    LPC_GPIO0->FIODIR  = partstFIO1_BITS;
    /* Start will all LEDs off. */
    LPC_GPIO0->FIOCLR = partstFIO1_BITS;

    // Switch
    LPC_GPIO2->FIODIR  &= ~0x00;    // Input mode
    LPC_PINCON->PINMODE4 |= 0x3f3;    // Pull-down P2.0,.2,.3,.4
    //xprintf("GPIO2     = %x\r\n", LPC_GPIO2->FIOPIN);
    //xprintf("GPIO2.DIR = %x\r\n", LPC_GPIO2->FIODIR);
}
/*-----------------------------------------------------------*/

void vParTestSetLED( unsigned portBASE_TYPE uxLED, signed portBASE_TYPE xValue )
{
    if( uxLED < partstNUM_LEDS )
    {
        /* Set or clear the output. */
        if( xValue )
        {
            LPC_GPIO0->FIOCLR = ulLEDs[ uxLED ];
        }
        else
        {
            LPC_GPIO0->FIOSET = ulLEDs[ uxLED ];
        }
    }
}
/*-----------------------------------------------------------*/

void vParTestToggleLED( unsigned portBASE_TYPE uxLED )
{
    if( uxLED < partstNUM_LEDS )
    {
        if( LPC_GPIO0->FIOPIN & ulLEDs[ uxLED ] )
        {
            LPC_GPIO0->FIOCLR = ulLEDs[ uxLED ];
        }
        else
        {
            LPC_GPIO0->FIOSET = ulLEDs[ uxLED ];
        }
    }
}
/*-----------------------------------------------------------*/

unsigned portBASE_TYPE uxParTextGetLED( unsigned portBASE_TYPE uxLED )
{
    if( uxLED < partstNUM_LEDS )
    {
        return ( LPC_GPIO0->FIOPIN & ulLEDs[ uxLED ] );
    }
    else
    {
        return 0;
    }
}
/*-----------------------------------------------------------*/
#else
void vParTestInitialise( void )
{
    /* LEDs on port 1. */
    LPC_GPIO1->FIODIR  = partstFIO1_BITS;
    /* Start will all LEDs off. */
    LPC_GPIO1->FIOCLR = partstFIO1_BITS;

    // Switch
    LPC_GPIO2->FIODIR  &= ~0x00;    // Input mode
    LPC_PINCON->PINMODE4 |= 0x3f3;    // Pull-down P2.0,.2,.3,.4
    //xprintf("GPIO2     = %x\r\n", LPC_GPIO2->FIOPIN);
    //xprintf("GPIO2.DIR = %x\r\n", LPC_GPIO2->FIODIR);
}
/*-----------------------------------------------------------*/

void vParTestSetLED( unsigned portBASE_TYPE uxLED, signed portBASE_TYPE xValue )
{
    if( uxLED < partstNUM_LEDS )
    {
        /* Set or clear the output. */
        if( xValue )
        {
            LPC_GPIO1->FIOCLR = ulLEDs[ uxLED ];
        }
        else
        {
            LPC_GPIO1->FIOSET = ulLEDs[ uxLED ];
        }
    }
}
/*-----------------------------------------------------------*/

void vParTestToggleLED( unsigned portBASE_TYPE uxLED )
{
    if( uxLED < partstNUM_LEDS )
    {
        if( LPC_GPIO1->FIOPIN & ulLEDs[ uxLED ] )
        {
            LPC_GPIO1->FIOCLR = ulLEDs[ uxLED ];
        }
        else
        {
            LPC_GPIO1->FIOSET = ulLEDs[ uxLED ];
        }
    }
}
/*-----------------------------------------------------------*/

unsigned portBASE_TYPE uxParTextGetLED( unsigned portBASE_TYPE uxLED )
{
    if( uxLED < partstNUM_LEDS )
    {
        return ( LPC_GPIO1->FIOPIN & ulLEDs[ uxLED ] );
    }
    else
    {
        return 0;
    }
}
/*-----------------------------------------------------------*/
#endif

unsigned int vParTestSW_Rec( void ){ //Record switch = P2.3 (mbed p23)
    //xputs("mbed P23 (LPC1768 p2.3) = ");
    //if (LPC_GPIO2->FIOPIN & 0x08){
    //    xputs("ON  \r\n");
    //} else {
    //    xputs("OFF \r\n");
    //}
    if (LPC_GPIO2->FIOPIN & 0x08){
        //xputs("ON  \r\n");
        return 0;
    } else {
        //xputs("OFF \r\n");
        return 1;
    }
}

unsigned int vParTestSW_Mode( void ){ //Record switch = P2.4 (mbed p22)
    //xputs("mbed P22 (LPC1768 p2.4) = ");
    //if (LPC_GPIO2->FIOPIN & 0x10){
    //    xputs("ON  \r\n");
    //} else {
    //    xputs("OFF \r\n");
    //}
    if (LPC_GPIO2->FIOPIN & 0x10){
        //xputs("ON  \r\n");
        return 0;
    } else {
        //xputs("OFF \r\n");
        return 1;
    }
}
/*-----------------------------------------------------------*/







