#ifndef _SIGNAL_H
#define _SIGNAL_H

enum SIGNAL_TYPE {
    NONE,
    CONSTANT,
    SINE,
    SQUARE
};

class Signal {
public:
    enum SIGNAL_TYPE type;
    float amplitude;
    float frequency;

    Signal(enum SIGNAL_TYPE type = NONE,
           float amplitude = 0,
           float frequency = 0) :
        type(type), amplitude(amplitude), frequency(frequency) {}

    void set(enum SIGNAL_TYPE _type, float _amplitude, float _frequency) {
        type=_type; amplitude=_amplitude; frequency=_frequency; }

    bool operator== (const Signal & s) {
        return type==s.type && amplitude==s.amplitude && frequency==s.frequency; }

    const char* c_str (char* str);
};

#endif

