#include "main.h"
#include "rtos.h"
#include <vector>
#include <algorithm>

std::vector<Signal> recall;


bool get_amplitude (float & amplitude) {
    if(!serial.scanf("%f", &amplitude))
        serial.puts("Invalid amplitude!\r\n");
    else if(!(0 <= amplitude && amplitude <= 3.3f))
        serial.puts("Amplitude not in range [0, 3.3].\r\n");
    else return 1;
    return 0;
}

bool get_frequency (float & frequency) {
    if(!serial.scanf("%f", &frequency))
        serial.puts("Invalid frequency!\r\n");
    else if(!(0 <= frequency && frequency <= 100000))
        serial.puts("Frequency not in range [0, 100000].\r\n");
    else return 1;
    return 0;
}


osThreadId mainThreadId;

void callback_on_input() {
    // inform mainThread that there is user input
    osSignalSet(mainThreadId, 0x1);
    //Thread::wait(1000);           // wait 1s
}

void userInterfaceFunc (void const* args) {
    mainThreadId = Thread::gettid();
    serial.attach(&callback_on_input);
    while(1) {
        serial.puts("\r\n");
        serial.puts("Enter signal to generate, in the form:\r\n");
        serial.puts("  * constant <amplitude>\r\n");
        serial.puts("  * sine <amplitude> <frequency>\r\n");
        serial.puts("  * square <amplitude> <frequency>\r\n");
        serial.puts("  * recall <index>\r\n");
        serial.puts("  * clear\r\n");

        char* str = buffer;
        Signal signal;

        while(1) {
            serial.puts("Choice: ");
            serial.flush();

            osSignalClear(mainThreadId, 0x1);   // ensure thread_signal is cleared
            Thread::signal_wait(0x1);           // now wait for that thread_signal
            serial.scanf("%s", str);            // then get the available user input

            if(0==strcmp(str, "constant")) {
                signal.frequency = 0;
                if(get_amplitude(signal.amplitude))
                { signal.type = CONSTANT; break; }
            }
            else if(0==strcmp(str, "sine")) {
                if(get_amplitude(signal.amplitude)
                && get_frequency(signal.frequency))
                { signal.type = SINE; break; }
            }
            else if(0==strcmp(str, "square")) {
                if(get_amplitude(signal.amplitude)
                && get_frequency(signal.frequency))
                { signal.type = SQUARE; break; }
            }
            else if(0==strcmp(str, "recall")) {
                int i, max = recall.size()-1;
                if(!serial.scanf("%d", &i))
                    serial.puts("Invalid index!\r\n");
                else if(i<0 || i>max)
                    serial.printf("Index not in range [0, %d].\r\n", max);
                else { signal = recall[i]; break; }
            }
            else if(0==strcmp(str, "clear")) {
                recall.clear();
                serial.puts("Done.\r\n");
            }
            else serial.puts("Invalid command!\r\n");
        }
        serial.printf("Done: %s.\r\n", signal.c_str(buffer));

        if(std::find(recall.begin(), recall.end(), signal) == recall.end()) // if signal does not already exists
        {
            serial.printf("Index of signal is %d.\r\n", recall.size());     // then add the new signal
            recall.push_back(signal);                                       // and provide its index
        }
        updateSignal(signal);
        serial.puts("----------------------\r\n");
    }
}

