#include "main.h"
#include "rtos.h"

DigitalOut greenLed (PD_12);
DigitalOut orangeLed (PD_13);
DigitalOut redLed (PD_14);
DigitalOut blueLed (PD_15);

AnalogOut *aout;
Timer timer;
const float pi = 3.141592653589793238462f;


//Mutex signalMutex;
bool signalHasChanged;
Signal signalToGenerate;

void updateSignal (Signal signal) {
    //signalMutex.lock();     // synchronise access with generateSignalFunc()
    signalToGenerate = signal;  // specify that the signal
    signalHasChanged = 1;       // to generate has changed
    //signalMutex.unlock();
}


void generateSignalFunc (void const* args) {
    enum SIGNAL_TYPE type;
    float a, f, p, t;
    timer.start();

    while(1) {
        if(signalHasChanged) {
            //signalMutex.lock();             // prevent changes to occur while
            type = signalToGenerate.type;   // signal parameters are being read
            a    = signalToGenerate.amplitude/3.3f; // scale from [0,3.3] to [0,1]
            f    = signalToGenerate.frequency;
            signalHasChanged = 0;           // reset flag
            //signalMutex.unlock();           // release lock
            greenLed = type==CONSTANT;
            orangeLed = type==SINE;
            redLed = type==SQUARE;
        }
        t = timer.read();       // get time t in seconds
        if(t>20) timer.reset(); // accuracy drops as t increases
        switch(type) {
            case CONSTANT:
                *aout = a;
                break;
            case SINE:
                *aout = a*0.5f*(1+sin(f*pi*2*t));
                break;
            case SQUARE:
                p = t*f - floor(t*f);
                *aout = (p < 0.5f) ? 0 : a;
                break;
            default: *aout = 0;
        }
    }
}

