#include "main.h"
#include "rtos.h"


void get_which_dac_to_use() {
    int dac = 1;
    while(1) {
        serial.puts("\r\n");
        serial.puts("Select which DAC to use:\r\n");
        serial.puts("  1 : DAC 1 (PA_4)\r\n");
        serial.puts("  2 : DAC 2 (PA_5)\r\n");
        serial.puts("Choice: ");
        serial.flush();
        serial.gets(buffer, BUFFER_SIZE);
        char* str = buffer;
        if(0==strcmp(str, "1")) { dac=1; break; }
        if(0==strcmp(str, "2")) { dac=2; break; }
        serial.puts("Invalid selection!\r\n");
    }
    if(dac==1) aout = new AnalogOut(PA_4);
    if(dac==2) aout = new AnalogOut(PA_5);
    serial.printf("Done: %d.\r\n", dac);
}


    void get_serial_port_ready() {
    for(int i=10; i>0; i--) {
        serial.printf("Wait %ds\r\n", i*2);
        wait(2);
    }
    serial.puts("***************************************\r\n");
    serial.puts("*** Welcome to my Signal Generator! ***\r\n");
    serial.puts("***************************************\r\n");
}


int main() {
    get_serial_port_ready();
    get_which_dac_to_use();
    Thread generateSignal(generateSignalFunc);
    userInterfaceFunc(NULL);
}

