#include "mbed.h"
#include "C12832.h"

Serial xbee(D1, D0);                    /* xbee link to device 1 */
Serial host(USBTX, USBRX);              /* Serial link to PC */
C12832 lcd(D11, D13, D12, D7, D10);     /* Shield LCD */
DigitalOut green_led_shield (PTA2);     /**/
DigitalOut red_led_shield (PTC4);       /* Shield LEDs */
DigitalOut blue_led_shield (PTA0);      /**/
PwmOut speaker(D6);                     /* Shield Speaker */

/* Makes the LED red */
void makeLEDRed (void)
{
    green_led_shield = 0;
    red_led_shield = 255;
    blue_led_shield = 0;
}

/* Makes the LED green */
void makeLEDGreen (void)
{
    green_led_shield = 255;
    red_led_shield = 0;
    blue_led_shield = 0;
}

/* Makes the LED yellow */
void makeLEDYellow (void)
{
    green_led_shield = 0;
    red_led_shield = 0;
    blue_led_shield = 255;
}

/* Sets device to normal state */
void setNormalState (void)
{
    makeLEDGreen();
    lcd.cls();
    lcd.locate (1,1);   //initial normal state.
    lcd.printf ("All Is Well With The World.");
}

/**
 * This program accepts data from device 1 and sends it to the PC program.
 * It then recieves data from the PC program acting as the router between device 1 and PC.
 * At certain status' the LCD and LED display different indicators.
 **/
int main()
{
    host.baud(38400);
    char input; //characters sent from device 1.
    char pcin;  //characters sent from PC.
    
    setNormalState();
    
    while(1)
    {
        if(xbee.readable()) //if recieiving data from device 1.
        {
            for(int i=0; i<8; i++) { //send host data for 8 char's. 4 for temp, 3 for degree and 1 for alert status.
                input = xbee.getc();
                host.printf("%c", input);
            }
            
            switch(input)   //using the last input to determin if alert or warning even happened from device 1.
            {
                case 'A':   //if received an a for alert (motion detected in the door).
                makeLEDRed();
                lcd.cls();  
                lcd.locate (1,1);
                lcd.printf ("ALERT!");
                lcd.locate (1,11);
                lcd.printf ("Motion Detected!");
                break;
                
                case 'W': //if received a warning about the temperature.
                makeLEDRed();
                lcd.cls();
                lcd.locate (1,1);
                lcd.printf ("WARNING!");
                lcd.locate (1,11);
                lcd.printf ("Abnormal Temperature!");
                break;
                
                case '0': //no alert handle case
                break;
            }                
                
            if(host.readable()) //receiving data from the PC program (GUI).
            {
                pcin = host.getc();
                switch(pcin) //using the PC program input to change status of device 1 and 2.
                {
                    case'y': //set status to normal as indicated by PC.
                    setNormalState();
                    break;
                    
                    case's': //sets status as investigating as indicated by the PC.
                    makeLEDYellow();
                    lcd.cls();
                    lcd.locate (1,1);
                    lcd.printf ("Issue Is Being Investigated.");
                    break;
                }     
                xbee.putc(pcin); //send data from PC to device 1.                 
            }     
        }
    }        
}