#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

#include "mbedtls/aes.h"

#define IV_SIZE     16
#define INPUT_SIZE  256

Serial pc(USBTX, USBRX);

// Indicator LED
DigitalOut myled(LED1);

// This function initializes the initilization vector to the original one.
void init_ivs(unsigned char iv_orig[], unsigned char iv1[], unsigned char iv2[]);


int main()
{
    int i=0;
    
    // We create two AES contexts
    mbedtls_aes_context aes;
    mbedtls_aes_context aes2;

    // Our KEY , should be shared only with the receiver and has to be as random as possible.
    // Here we use this simple example for ease and simplicity
    unsigned char key[32] = "1234567812345678123456781234567" ; 
    key[31] = '8';   // we replace the 32th (index 31) which contains '/0' with the '8' char.

    // This is the Init Vector generated with the random KEY from http://aes.online-domain-tools.com/
    unsigned char orig_iv[] = {0x8d, 0xf8, 0x4d, 0xed, 0x5f, 0xbd, 0x51, 0x57, 0x5c, 0x55, 0x17, 0xb0, 0x66, 0xee, 0xb1,  0x2b}; // e053a4a22fd6bfaf43fd5e8b5"; {0xb2, 0x4b, 0xf2, 0xf7, 0x7a, 0xc5, 0xec, 0x0c, 0x5e, 0x1f, 0x4d, 0xc1, 0xae, 0x46, 0x5e, 0x75};
    unsigned char iv1[IV_SIZE] = {0};
    unsigned char iv2[IV_SIZE] =  {0};

    // This is the text that we want to encrypt and send
    unsigned char my_txt[] = "My name is Ritesh Reddy Sadula";

    unsigned char input[INPUT_SIZE] = {0};
    
    for(int m=0; m<strlen((const char*)my_txt); m++)
    {
        input[m] = *(my_txt+m);
    }
       

    // Output of encryption
    unsigned char output[INPUT_SIZE] = {0};
    // Output of decryption
    unsigned char output2[INPUT_SIZE] = {0};
 
    int ret =0;
    
    // To be a valid length, it has to be a multiple of 16, so we take the muliple of 16 that is nearly bigger than the actual size
    // Or the 
    int TXT_VALID_LENGTH = ((strlen((const char*)my_txt)%16 == 0)  ?  strlen((const char*)my_txt) :  (strlen((const char*)my_txt)/16 + 1)*16);
    while(1){
        init_ivs(orig_iv , iv1, iv2);
        
        
        mbedtls_aes_setkey_enc( &aes, key, 256);
        ret = mbedtls_aes_crypt_cbc( &aes, MBEDTLS_AES_ENCRYPT, TXT_VALID_LENGTH, iv1, input, output );
        pc.printf("%d  -  Ret: %d  - strlen(input)=%d -  ENCRYPTED output  %s\n", i, ret , TXT_VALID_LENGTH, output);
        
        // We can use 64encoding to send data and to avoid encoding problems
        // In our case we use haxadecimal representation of the characters so no need.  
       // mbedtls_base64_encode(encoded64, 200, &out_len, (const unsigned char *)output, strlen((const char*)output) );
       // printf("%d  64ENCODED ENCRYPTED  output  %s\n", i, encoded64);
       
        pc.printf("%d  HEX ENCRYPTED output\n", i);
        for(int j=0; j<TXT_VALID_LENGTH; j++)
        {
            pc.printf("%02x ", output[j]);
        }
        pc.printf("\n");
        
        // We decrypt the OUTPUT1 and we get the same input string
    
        mbedtls_aes_setkey_dec( &aes2, key, 256);
        ret = mbedtls_aes_crypt_cbc(&aes2, MBEDTLS_AES_DECRYPT, TXT_VALID_LENGTH, iv2, output, output2 );
        pc.printf("%d  -  Ret: %d  -  DECRYPTED output  %s\n\n", i , ret,  output2);
        
        // Showing the decrypted result in HEX
        pc.printf("%d  HEX DECRYPTED output\n", i, output2);
        for(int j=0; j<TXT_VALID_LENGTH; j++)
        {
            pc.printf("%02x ", output2[j]);
        }
        pc.printf("\n\n\n");
    
        i++;
        // Wait 2 seconds and re-do it.
        wait(2);
    }
    
}

void init_ivs(unsigned char iv_orig[], unsigned char iv1[], unsigned char iv2[])
{
    for(int i=0; i<IV_SIZE; i++){
    
         iv2[i] = iv1[i] = iv_orig[i];
        
    }
}