#include "MCP4922.h"
#include "mbed.h"

MCP4922::MCP4922(PinName MOSI,PinName SCK,PinName CS,PinName LDAC):
    dac_SPI(MOSI,NC,SCK),dac_cs(CS),dac_l(LDAC)
{
    dac_SPI.format(16,0);
    dac_SPI.frequency(20000000);
    dac_cs=1;
    dac_l=1;
}

void MCP4922::write(int ch,float value)
{
    if(value<0) {
        value=0;
    } else if(value>1) {
        value=1;
    }
    dac_cs=0;
    int data;
    if(ch==0) {
        data=(0b0011<<12)|(int)(value*0xFFF);
    } else if(ch==1) {
        data=(0b1011<<12)|(int)(value*0xFFF);
    }
    dac_SPI.write(data);
    dac_cs=1;
    dac_l=0;
    dac_l=1;
}
