#ifndef __KT0915_H
#define __KT0915_H

#include "mbed.h"

#define KT0915_address 0x6A

/** Library for KT0915
*/
class KT0915
{
public:
    /** Create a KT0915 instance connected to specified I2C pins
        *
        * @param sda I2C-bus SDA pin
        * @param scl I2C-bus SCL pin
        */
    KT0915(PinName sda,PinName scl);
    /**Initialize KT0915
    *
    *Set paramaters below
    *
    *0x02:0b0000000000000111 FM space:100KHz, R/L mute:disable
    *
    *0x04:0b1110000010010000 FM/AM/device mute:disable, bass:disable DAC cap:60uF
    *
    *0x05:0b1001100000100000 Mono:enable, de-emphasis:50uF, blend:disable
    *
    *0x0A:0b0000010000000000 LDO:highest, FM AFC:enable
    *
    *0x0C:0b0000000000101100 FM wide freq:enable
    *
    *0x0F:0b1000100000000000 Stanby:disable, volume:0
    *
    *0x16:0b0000000011000010 Mode:FM, use internal defined band, Audio gain:0dB, AM AFC:enable
    *
    *0x22:0b1010001011101100 AM AGC fast win:fastest, AM AGC short win:slowest
    *
    *AM bandwidth:6KHz, AM gain:12dB, Left Inverse Control:enable
    *
    *0x23:0bxxx111xxxxxxxxxx low th:B
    *
    *0x2E:0b0010100010001100 softmute:fast, AM softmute start level:0b100
    *
    *softmute target volume:0b0100, softmute mode:RSSI, FM softmute start threshold:0b100
    *
    *0x33:0b0101010000000001 AM space:9KHz
    *
    *0x3F:0bxxxxxxxxx001x011 RF AGC patch
    */

    void init(void);

    /**read KT0915_WHO_AM_I
    *
    *return 0x4B54
    */
    int getID(void);

    /**set volume
    *
    *vol...0~31
    */
    void set_vol(int vol);

    /**set frequency and tune
    *
    *AM...mode=1, freq=frequency (KHz)
    *
    *FM...mode=0, freq=100*frequency (MHz)
    */
    void set_freq(bool mode,int freq);

    /**set xtal frequency
    *
    *xtal=32,38,12000,24000 (KHz)
    *
    *If your xtal is 32.768Khz,set to 32.
    */
    void set_xtal(int xtal);

    /**read RSSI (dB)
    *
    *AM...mode=0
    *
    *FM...mode=1
    */
    int get_rssi(bool mode);

    /**set channel space
    *
    *AM...mode=0, space=1,9,10 (KHz)
    *
    *If space=1, bandwidth sets 2KHz.
    *
    *If space=9 or 10, bandwidth sets 6KHz.
    *
    *FM...mode=1, space=50,100,200 (KHz)
    */
    void set_space(bool mode,int space);

    /**read SNR (dB)
    *
    *for FM only
    */
    int get_snr(bool mode);

    /**read Chip Ready Indicator
    *
    *0...Chip is not ready.
    *
    *1...Chip is ready.
    */
    bool get_ready(void);

    /**re-cali*/
    void cali(void);

private:
    I2C _KT0915;
    void write_reg(int memory_address,int byte1,int byte2);
    void read_reg(int memory_address,int *byte1,int *byte2);
    int data1,data2;
};

#endif
