#include "uLCD_4DGL.h"

class Ball
{
public:    
    Ball (uint8_t, uint8_t, uint8_t);
    // Set Functions
    void setVx(double); // This sets the velocity
    void setVxDir(bool);
    void setVy(double); // This sets the velocity
    void setVyDir(bool);
    // Get Functions
    uint8_t getSize();
    uint8_t getX();
    uint8_t getY();
    uint8_t getFutureX();   // get estimate of where the ball will be in the next update()
    uint8_t getFutureY();   // get estimate of where the ball will be in the next update()
    // Member Functions
    void reverseXDirection(); // negate the sign for when a ball hits something
    void reverseYDirection(); // negate the sign for when a ball hits something
    void reset(uint8_t, uint8_t, int, int); // takes in a new location and new directions and draws the starting point for the ball
    void update(); // moves the ball on the screen one vx and vy
    
private:
    double vx;
    bool vxDir; //false is left (-x), true is right (+x)
    double vy;
    bool vyDir; //false is up (-y), true is down (+y)
    double x;
    double y;
    uint8_t diameter;
};
