#include "MQTTmbed.h"
#include <MQTTClientMbedOs.h>
#include <cstdio> 
#include "mbed.h"
#include "hcsr04.h"

 int main(int argc, char *argv[]) {
 long distance = sensor.distance(); 
 long distanza =  distance;
 printf("distanza  %d  \n",distanza);
 printf("Starting IBM MQTT demo:\n");
 TCPSocket socket;
 NetworkInterface *net = NetworkInterface::get_default_instance();
 if (!net) {
   printf("Error! No 11network inteface11 found.\n");
   return 0; }
 printf("Connecting to the network...\r\n");
 nsapi_size_or_error_t rc = net->connect();
 if (rc != 0) {
   printf("Error! _net->connect() returned: %d\r\n", rc);
   return -1; }
 rc = socket.open(net);
 if (rc != 0) {
   printf("Error! _socket.open() returned: %d\r\n", rc);
   return -1; }
 SocketAddress address;
 net->gethostbyname("dev.rightech.io",
                    &address);
 address.set_port(1883);
 printf("Opening connection to remote %s port %d\r\n",
        address.get_ip_address(), address.get_port());
 rc = socket.connect(address);
 if (rc != 0) {
   printf("Error! _socket.connect() returned: %d\r\n", rc);
   return -1; }
 printf("Connected socket\n");
 MQTTClient client(&socket);
 MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
 data.MQTTVersion = 3;
 data.clientID.cstring = "distanza1";
 data.username.cstring = "AFAC";
 data.password.cstring = "As123456";
 if ((rc = client.connect(data)) != 0)
   printf("rc from MQTT connect is %d\r\n", rc);
 MQTT::Message message;
 char *topic = "ss";
 char buf[100];
 int temp = 1;
 int press = 2;
 int hum = 3;
 //sprintf(buf,
 //        "{\"d\":{\"ST\":\"Nucleo-IoT-mbed\",\"Temp\":%d,\"Pressure\":"
 //        "%d,\"Humidity\":%d}}", temp, press, hum);
 sprintf(buf,
            "{\"distanza\": %d}", distanza);
 printf("Sending message: \n%s\n", buf);
 message.qos = MQTT::QOS0;
 message.retained = false;
 message.dup = false;
 message.payload = (void *)buf;
 message.payloadlen = strlen(buf);
 rc = client.publish(topic, message);
 printf("Message sent\n");
 printf("Demo concluded successfully \r\n");
 return 0; }
