#include "mbed.h"
#include "mbedWSEsbc.h" 
#define PI (3.14159)

LocalFileSystem local ("local");
float Ts = 0.001; // Sampling period 1/Ts Hz 
 
// Arrays for data storage
float etime[1000];
float ang_pos[1000];
float est_speed[1000];
float dc_in[1000];
 
 // Open "results.M" on the local file system for writing
FILE *fp = fopen("/local/gnMot1e.M", "w");
 
float cntr;
float ang,angp,speed;
float dt;
float dc;
long enc1;
float K,dspeed;
int k; 
 
int main ()
{    
    mbedWSEsbcInit(921600);
    
    // Reset cntr used to keep track of sample period and elpased time
    cntr = 0.0; 
    
    // Gain design parameters
    K = ;
    dspeed = 40; // rad/sec
    
    // initialize data vectors
    for(k=0; k<1000; k++) {
        etime[k] = 0.0;
        ang_pos[k] = 0.0;
        est_speed[k] = 0.0;
        dc_in[k] = 0.0;
    }
    k = 0; // Reset index counter
    angp = 0; // initialize previous angle variable to zero
 
    while(cntr <= 1000) {
        t.start(); // start measuring comp time

        // Read encoder
        enc1 = LS7366_read_counter(1);

        // Convert from counts to radians
        ang = -2*PI*enc1/6500.0;

        // Estimate speed
        speed = (ang-angp)/Ts;

        // Age variables
        angp = ang;

        // Drive motor 
        dc = -0.35;
        
        if (cntr >= 1000) {
            dc = 0.0;
        }

        // Log data
        etime[k] = cntr*Ts;
        ang_pos[k] = ang;
        est_speed[k] = speed;
        dc_in[k] = dc;

        k++;
        
        // motor control
        mot1_ph1 = 0;
        mot1_ph2 = 1;
        mot_en1 = abs(dc);

        t.stop(); // end measuring comp time
        dt = Ts-t.read();
        //printf("%5.2f\n\r",cntr);
        pc.printf("%5.2f %5.2f %5.2f \n\r",cntr*Ts,speed,dc);
        //pc.printf("%5.2f %d \n\r",cntr*Ts,enc1);

        t.reset();
        cntr=cntr+1;
        wait(dt); // wait to ensure sampling period set by Ts
        //if (cntr == 200){fclose(fp);}

    }//while

    // Print out log variables in MATLAB structured variable format.
    pc.printf("Printing log variables to file on mBed           ... ");

    dc_in[0] = K*dspeed;

    if(1) {
        for(k=0; k<1000; k++) {
            fprintf(fp,"t(%d,1) = %.5f;\n",k+1,etime[k]);
            fprintf(fp,"est_speed(%d,1) = %.5f;\n",k+1,est_speed[k]);
            fprintf(fp,"dc_in(%d,1) = %.5f;\n",k+1,dc_in[k]);
        }
    }
    printf("done.\r\n");

    // Close file
    fclose(fp);
    
}//main
