///////////////////////////////////////////////////////////////////////////////
// TrainInfo: Next train and delayed information library   by rinos 2010
///////////////////////////////////////////////////////////////////////////////

#include "TrainInfo.h"
#include "HTTPClient.h"

////////////////////////////////////////////////////////////////////////////////
// defines
const int MAX_LINE_BUF = 256;

////////////////////////////////////////////////////////////////////////////////
// TrainInfo

TrainInfo::TrainInfo(const char* inifile) {
    m_delay[0] = 0;
    if(inifile) open(inifile);
}

TrainInfo::~TrainInfo(){
    close();
}

////////////////////////////////////////////////////////////////////////////////
// internal funcs
////////////////////////////////////////////////////////////////////////////////
// Open NextTrain format file and read option data
TrainInfo::Status TrainInfo::open(const char* inifile){
    if(m_ini.open(inifile)) return S_INI_OPEN_ERROR;

    // Set parameters from INI file
    char tbl[MAX_LINE_BUF];
    if(m_ini.get("NextTrain", tbl, sizeof(tbl))) return S_INI_FORMAT_ERROR;

    // Setup NextTrain information
    if(m_ntf.open(tbl)) return S_NEXTTRAIN_OPEN_ERROR;
    
    char delim[2];
    if(m_ini.get("DelimChar", delim, 2) == S_SUCCESS) m_ntf.set_delim(delim[0]);
    return S_SUCCESS;
}

TrainInfo::Status TrainInfo::close(){
    m_ntf.close();
    return S_SUCCESS;
}

// Delay information I/F
const char INET_TEMP_FILE[] = "/local/temp1.dat";

TrainInfo::Status TrainInfo::checkDelay(){
    m_delay[0] = 0;

    // check ini configuration
    int delayType = 0;
    char buf[MAX_LINE_BUF];
    if(m_ini.get("DelayType", delayType) || delayType == DTYPE_NONE) return S_DELAY_NOINFO; // no delay information
    if(delayType >= DTYPE_MAX) return S_DELAY_TYPE_ERROR;
    if(m_ini.get("DelayURL", buf, sizeof(buf))) return S_INI_FORMAT_ERROR;

    if(!memcmp(buf, "http:", 5)){
//#define DIRECT_READ 1
#ifdef DIRECT_READ
        HTTPFile cache(INET_TEMP_FILE);
        HTTPResult ret = http.get(buf, &cache);
#else
        FILE* fp = fopen(INET_TEMP_FILE, "w");
        if(!fp) return S_DELAY_WRITE_ERROR;
		HTTPClient http;
        int ret = http.get(buf, fp);
        fclose(fp);
        printf("HTTPClient download %d bytes\n", ret);
#endif
        if(!ret){
            printf("HTTPClient::get failed %d\n", ret);
            return S_DELAY_DOWNLOAD_ERROR;
        }
        strcpy(buf, INET_TEMP_FILE);
    }

    FILE* fp = fopen(buf, "rb");
    if(!fp) return S_DELAY_WRITE_ERROR;

    int end = 0;
    while(!end && fgets(buf, sizeof(buf), fp)){
        switch(delayType){
        case DTYPE_TOKYU: // TOKYU TOP PAGE MODE
            {
                char* p = strchr(buf, '\'');
                if(p){
                	char* p2 = strrchr(++p, '\'');
                	if(p2){ // detect!
	                    // buf is SJIS
                		*p2 = 0;
	                    IniFile::strtrim(m_delay, p, sizeof(m_delay));
	                    p = strstr(m_delay, "\0x95\0xBD\0x8F\0xED");
	                    printf("DELAY %d='%s'\n", p? 1 : 0, m_delay);
	                    fclose(fp);
	                    return p? S_DELAY_NONE : S_DELAY_DETECTED; // SJIS-"HEIJO"
                	}
                }
            }
            break;
        }
    }
    fclose(fp);
    // if message exist
    printf("DELAY: NoInfo\n");
    return S_DELAY_NOINFO;
}

TrainInfo::Status TrainInfo::getDelayMessage(char* buf, int size){
    int len = strlen(m_delay);
    if(len > size - 1) len = size - 1;
    memcpy(buf, m_delay, len);
    buf[len] = 0;
    return S_SUCCESS;
}
