///////////////////////////////////////////////////////////////////////////////
// TrainInfo: Next train and delayed information library   by rinos 2010
///////////////////////////////////////////////////////////////////////////////

#ifndef __TRAININFO_H__
#define __TRAININFO_H__

#include "NextTrainFile.h"
#include "IniFile.h"

class TrainInfo {
    // defines /////////////////////////////////////////////////////////////////
public:
    typedef enum {
        DTYPE_NONE,
        DTYPE_TOKYU,
        DTYPE_MAX,
    } DelayType;

    static const int MAX_DELAY_MESSAGE = 256;

    // error code
    typedef enum {
        S_SUCCESS = 0,
        S_INI_OPEN_ERROR,
        S_ALREADY_OPEN,
        S_INI_FORMAT_ERROR,

        S_NEXTTRAIN_OPEN_ERROR = 100,
        S_NEXTTRAIN_OPTION_OVERFLOW,
        S_NEXTTRAIN_NO_TRAIN,
        S_NEXTTRAIN_INVALID_OPTION_ID,

        S_DELAY_DETECTED = 200,
        S_DELAY_NONE,
        S_DELAY_TYPE_ERROR,
        S_DELAY_WRITE_ERROR,
        S_DELAY_DOWNLOAD_ERROR,
        S_DELAY_NOINFO,
    } Status;

    // internal member/method //////////////////////////////////////////////////
private:
    IniFile       m_ini;
    NextTrainFile m_ntf;
    char          m_delay[MAX_DELAY_MESSAGE];

    // Invalid method
protected:
    TrainInfo(const TrainInfo& v);
    const TrainInfo& operator =(const TrainInfo& v);

public:
    TrainInfo(const char* inifile = 0);
    ~TrainInfo();

    Status open(const char* inifile);
    Status close();

    // NextTrainFile I/F
    void use_shortopt(bool f) {
        m_ntf.use_shortopt(f);
    }
    NextTrainFile::Status search(time_t dt = 0, int offset = 0) {
        return m_ntf.search(dt, offset);
    }
    const NextTrainFile::NextInfo* next() const {
        return m_ntf.next();
    }

    // Delay information I/F
    Status checkDelay();
    Status getDelayMessage(char* buf, int size);
};

#endif
