///////////////////////////////////////////////////////////////////////////////
// NextTrainFile: NextTrain file parser   by rinos 2010
///////////////////////////////////////////////////////////////////////////////

#include "NextTrainFile.h"

#define 	ROOT_PATH	"/local/"
#define 	ROOT_LEN	(sizeof(ROOT_PATH) - 1)

const char NT_FILE[] = ROOT_PATH "test.tbl";

int main() {
	LocalFileSystem local("local");
	
	NextTrainFile ntf(NT_FILE);
	
	time_t now = time(0);
	
	for(int i = 0 ; i < 24 ; ++i){
    	struct tm* st = localtime(&now);
		printf("NextTrainFile:  W(%d)%02d:%02d:%02d: ", st->tm_wday, st->tm_hour, st->tm_min, st->tm_sec);
		NextTrainFile::Status ret = ntf.search(now);
		if(ret){
			printf("No train (error %d)\n", ret);
		} else {
			const NextTrainFile::NextInfo* p = ntf.next();
			printf("Next:%02d:%02d(%s) \tLeft:%5ds (%s)\n", p->m_hour, p->m_min, p->m_option, p->m_diff, p->m_title);
		}
		now = now + 3600 - 5 * 60;
	}
	
	return 0;
}


/* test.tbl

; ͌ ݂胉hw z
a:{;
b:㐅;
c:Vh;V
d:哇;
e:z;
f:{;{
g:;
h:ʋΉ;
i:;
j:^];

[MON][TUE][WED][THU][FRI]
# ݂胉h z()
5: ic14 ie19 hc33 ie39 ie54
6: ic09 ic24 ic34 ic44 hc52 ic56
7: hf01 hc04 ic09 hc14 ic21 hf27 hc33 ic42 hf46 ic51 hc54
8: ic02 hd07 hc14 ic22 hd29 ic36 ic46 hc51
9: hf01 hf10 hc18 hf25 gf42 gc58
10: gf06 gc20 gc38 ie47
11: gc00 ie06 gc20 ie27 gc40 ie46
12: gc00 ie06 gc20 ie26 gc40 ie46
13: gc00 ie06 gc20 ie26 gc40 ie46
14: gc00 ie06 gc20 ie26 gc40 ie46
15: gc00 ie06 gc20 ie26 gc40 ie46
16: gc00 ie06 gc20 ie26 gc40 ie46 ie57
17: gf05 ie17 ie27 ie37 ie47 ie57
18: ie07 ie17 ie27 ie37 ie47 ie57
19: ie07 ie17 ie27 ie37 ie47 ie57
20: ie07 ie17 ie27 ie37 ie47 ie57
21: ie07 ie17 ie27 ie37 ie47 ie57
22: ie07 ie17 ie25 gf31 ie36 ie44 if50
23: ic06 gc12 ie22 gc29 ia39 ie56

[SAT][SUN][HOL]
# ݂胉h z(yx)
5: ic14 ic34 ie52
6: ie06 ie26 ie36 ic46 ie51
7: gd04 ie14 gd23 ie30 ib36 gd45 ic56
8: gd08 gc17 ie25 gc40 ie45
9: gc00 ie06 gc20 ie24 gc40 ie47
10: gc00 ie06 gc20 ie26 gc40 ie46
11: gc00 ie06 gc20 ie26 gc40 ie46
12: gc00 ie06 gc20 ie26 gc40 ie46
13: gc00 ie06 gc20 ie26 gc40 ie46
14: gc00 ie06 gc20 ie26 gc40 ie46
15: gc00 ie06 gc20 ie26 gc40 ie46
16: gc00 ie06 gc20 ie26 gc40 ie46 gc58
17: ie06 gc19 ie26 gc39 ie46 gc59
18: ie06 gc19 ie24 gf29 ie43 gf49 ie55
19: gf09 ie16 gf30 ie36 gf50 ie56
20: gf10 gc20 gf30 gc40 gf50
21: gc00 gf10 gc20 ie29 ie38 ie47 ie57
22: ie07 ie17 ie26 ie34 ie46 ie56
23: ie06 ie16 ie30 ia40 ie56
*/