///////////////////////////////////////////////////////////////////////////////
// NextTrainFile: NextTrain file parser   by rinos 2010
///////////////////////////////////////////////////////////////////////////////

#ifndef __NEXTTRAIN_FILE_H__
#define __NEXTTRAIN_FILE_H__

#include "mbed.h"

class NextTrainFile {
	// defines /////////////////////////////////////////////////////////////////
public:
	enum LINE_TYPE {
		LINE_COMMENT,
		LINE_TITLE,
		LINE_TIME,
		LINE_WEEK,
		LINE_OPTION
	};
	
	static const int HOUR_DIV		= 3;	// Last Train AM 03:00
	
	static const int MAX_TITLE		= 80;
	static const int MAX_OPTION		= 80;
	
	static const int MAX_OPTIONID	= 52;	// A-Za-z
	static const int MAX_OPTBUF		= 256;	// m_index (unsigned char) range

	struct NextInfo {
		char  m_title [MAX_TITLE];
		char  m_option[MAX_OPTION];
		unsigned int   m_hour;
		unsigned int   m_min;
		signed   int   m_diff;
		
		NextInfo() : m_hour(0), m_min(0), m_diff(0) {
			m_title[0]  = 0;
			m_option[0] = 0;
		}
	};

	// error code
	typedef enum {
		S_SUCCESS,
		S_OPEN_ERROR,
		S_ALREADY_OPEN,
		S_OPTION_OVERFLOW,

		S_NO_TRAIN,
		S_INVALID_OPTION_ID,
	} Status;

	// internal member/method //////////////////////////////////////////////////
private:
	FILE*    m_fp;
	NextInfo m_ni;
	bool     m_shortopt;
	char     m_delim;

	unsigned char m_index [MAX_OPTIONID];
	char          m_optbuf[MAX_OPTBUF];
	
	// Invalid method
protected:
	NextTrainFile(const NextTrainFile& v);
	const NextTrainFile& operator =(const NextTrainFile& v);

public:
	NextTrainFile(const char* ntFile = 0);
	~NextTrainFile();

	Status open(const char* ntFile);
	Status close();
	void   use_shortopt(bool f) { m_shortopt = f; }
	void   set_delim   (char d) { m_delim    = d; }
	Status search(time_t dt = 0, int offset = 0);
	const NextInfo* next() const { return &m_ni; }
};

#endif
