#include "mbed.h"
#include "NJE10XCtrl.h"

struct Mytest{
    const char* msg;
    NJE10XCtrl::Attr1 a1;
    NJE10XCtrl::Attr2 a2;
    NJE10XCtrl::Attr3 a3;
};
Mytest MY_TEST[] = {
#define X_TEST(a1,a2,a3) {#a1"+"#a2"+"#a3, NJE10XCtrl::ATTR_##a1, NJE10XCtrl::ATTR_##a2, NJE10XCtrl::ATTR_##a3}
    X_TEST(GREEN,  SCROLL,    NORMAL),
    X_TEST(RED,    SCROLL_R,  REVERSE),
    X_TEST(YELLOW, STOP,      NORMAL),
    X_TEST(GREEN,  FIX,       REVERSE),
    
    X_TEST(RED,    SCROLL,    BLINK_REVERSE),
    X_TEST(YELLOW, SCROLL_R,  BLINK),
    X_TEST(GREEN,  STOP,      BLINK_REVERSE),
    X_TEST(RED,    FIX,       BLINK),
#undef  X_TEST
    {0},
};

int main() {
    printf("Initialize NJE105...\n");
    NJE10XCtrl nje(p9);
    nje.reset();
    
    printf("Wait for completing the reset...\n");
    wait(20); // wait the reset complete
    nje.setMessage(1, "Start NJE10XCtrl test...", NJE10XCtrl::ATTR_YELLOW, NJE10XCtrl::ATTR_SCROLL_R);
    wait(8);
    
    int op = 0;
    int n = 0;
    const char* op_msg = "";
    for(;;){
        if(n == 0){
            if(++op > 2) op = 0;
            const char* OP_MSGS[3] = {"Slow", "Middle", "Fast"};
            op_msg = OP_MSGS[op];
            nje.setMessage(1, op_msg);
            nje.setScrollSpeed(NJE10XCtrl::ScrollSpeed(op));
            nje.setBlinkSpeed(NJE10XCtrl::BlinkSpeed(op + 1));
            nje.setStopTime(3 - op);
            printf("Set mode to %s (Wait %dsec...)\n", op_msg, 50 - op * 20);
            wait(50 - op * 20); // 50 30 10
        }

        const Mytest& mt = MY_TEST[n];
        char buf[99];
        sprintf(buf, "#%d:%s/", n + 1, mt.msg);
        nje.clear();
        nje.add(buf);
        nje.addAttr(NJE10XCtrl::Attr1((mt.a1 + 1) & 3), mt.a2, mt.a3);
        nje.add(op_msg);
        nje.setMessage(1, 0, mt.a1, mt.a2, mt.a3);

        printf("Show '%s', wait %dsec\n", buf, 25 - op * 5);
        wait(20 - op * 5);

        if(!MY_TEST[++n].msg) n = 0;
    }
}
