///////////////////////////////////////////////////////////////////////////////
// Sample IniFileLib program   by rinos 2010
///////////////////////////////////////////////////////////////////////////////

// test.ini
// | # Sample INI file
// | NTPServer	= ntp.jst.mfeed.ad.jp
// | NTPPort	= 0x123
// | EnableNTP	= False

// Ini file value (int/bool/string)
// Key1 = 123            -> 123         (int)
// Key2 = 0x123          -> 291         (int)
// Key3 = FALSE          -> false       (bool)
// Key4 = TRUE           -> true        (bool)
// Key5 = 123            -> true        (bool)
// key6 =   abc "def     -> 'abc "def'  (string)
// key7 = " ghi "jkl "   -> ' ghi "jkl '(string)
// #comment line

#include "IniFile.h"

#define 	ROOT_PATH	"/local/"
#define 	ROOT_LEN	(sizeof(ROOT_PATH) - 1)

const char INI_FILE[] = ROOT_PATH "test.ini";

const char DEFAULT_NTP_SERVER[]	= "ntp.jst.mfeed.ad.jp";
const int  DEFAULT_NTP_PORR		= 123;
const bool DEFAULT_NTP_ENABLE	= true;

const int  INI_BUF = 100;

int main() {
	LocalFileSystem local("local");

	{// static function call sample
		char   ntp_server[INI_BUF];
		int    ntp_port		= DEFAULT_NTP_PORR;
		bool   ntp_enable	= DEFAULT_NTP_ENABLE;
		strcpy(ntp_server, DEFAULT_NTP_SERVER);
		
		IniFile::getval(INI_FILE,	"NTPServer",	ntp_server, sizeof(ntp_server));
		IniFile::getval(INI_FILE,	"NTPPort",		ntp_port);
		IniFile::getval(INI_FILE,	"EnableNTP",	ntp_enable);

	    printf("IniFile1: server=%s:%d mode=%d\n", ntp_server, ntp_port, ntp_enable);
	}
	
	{// static function call sample
		char   ntp_server[INI_BUF];
		int    ntp_port		= DEFAULT_NTP_PORR;
		bool   ntp_enable	= DEFAULT_NTP_ENABLE;
		strcpy(ntp_server, DEFAULT_NTP_SERVER);
		
		IniFile ini(INI_FILE);
		
		ini.get("NTPServer",	ntp_server, sizeof(ntp_server));
		ini.get("NTPPort",		ntp_port);
		ini.get("EnableNTP",	ntp_enable);

	    printf("IniFile1: server=%s:%d mode=%d\n", ntp_server, ntp_port, ntp_enable);
	}
	
	{// list function call sample
		char   ntp_server[INI_BUF];
		int    ntp_port		= DEFAULT_NTP_PORR;
		bool   ntp_enable	= DEFAULT_NTP_ENABLE;
		strcpy(ntp_server, DEFAULT_NTP_SERVER);
		
		IniFile::IniList INILIST[] = {
			{"NTPServer",	sizeof(ntp_server),		ntp_server},
			{"NTPPort",		IniFile::DTYPE_INT,		&ntp_port},
			{"EnableNTP",	IniFile::DTYPE_BOOL,	&ntp_enable},
			0 // END
		};

		IniFile::getval(INI_FILE, INILIST);
		
	    printf("IniFile1: server=%s:%d mode=%d\n", ntp_server, ntp_port, ntp_enable);
	}
	
	return 0;
}
