#include "TimeHandler.h"
#include <time.h>

#include "dbg/dbg.h"

TimeHandler::TimeHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)
{
}

TimeHandler::~TimeHandler()
{
  DBG("Handler destroyed\r\n");
}

const char* res1 = 
"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n\
<HTML>\n\
<HEAD>\n\
<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;charset=Shift_JIS\">\n\
<META HTTP-EQUIV=\"Content-Script-Type\" CONTENT=\"text/javascript\">\n\
<TITLE>DiffTime</TITLE>\n\
</HEAD>\n\
<BODY>\n\
<SCRIPT LANGUAGE=\"javascript\" TYPE=\"text/javascript\">\n\
<!--\n\
var d_ini = new Date();\n\
var d_svr = new Date(\"";

const char* res3 = 
"\");\n\
document.write(\"<FORM NAME='form1'><INPUT TYPE='text' NAME='text1' SIZE=100><br><INPUT TYPE='text' NAME='text2' SIZE=100></FORM>\");\n\
ShowDiff();\n\
function ShowDiff(){\n\
	var d_pc = new Date();\n\
	var d_ts = new Date(d_svr - (d_ini - d_pc));\n\
	document.form1.text1.value = \"TS:\" + d_ts.toString();\n\
	document.form1.text2.value = \"PC:\" + d_pc.toString() + \" (Diff:\" + Math.round((d_ini - d_svr) / 1000) + \" [sec])\";\n\
	setTimeout(\"ShowDiff()\",1000);\n\
}\n\
// -->\n\
</SCRIPT>\n\
</BODY>\n\
</HTML>\n";

void setTestRTC(){
    struct tm t;
    t.tm_year = 2011 - 1900; //109 year since 1900
    t.tm_mon  =  2 - 1; //9 0-11
    t.tm_mday =  4; //28 1-31
    t.tm_hour =  2; //11 0-23
    t.tm_min  = 36; //42 0-59
    t.tm_sec  =  0; //37 0-59
    set_time(mktime(&t));
}

void TimeHandler::doGet()
{
  DBG("In TimeHandler::doGet()\r\n");
  
  //setTestRTC(); // for diff debug
  
  time_t now = time(0);
  struct tm *t = localtime(&now);
  char res2[100];
  sprintf(res2, "%04d/%02d/%02d %02d:%02d:%02d", t->tm_year + 1900, t->tm_mon + 1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec);
  printf("HTTPD TimeHandler RTC=%s\n", res2);

  int len1 = strlen(res1);
  int len2 = strlen(res2);
  int len3 = strlen(res3);

  setContentLen( len1 + len2 + len3);
  respHeaders()["Connection"] = "close";
  writeData(res1, len1);
  writeData(res2, len2);
  writeData(res3, len3);
  DBG("Exit TimeHandler::doGet()\r\n");
}

void TimeHandler::doPost()
{

}

void TimeHandler::doHead()
{

}

  
void TimeHandler::onReadable() //Data has been read
{

}

void TimeHandler::onWriteable() //Data has been written & buf is free
{
  DBG("TimeHandler::onWriteable() event\r\n");
  close(); //Data written, we can close the connection
}

void TimeHandler::onClose() //Connection is closing
{
  //Nothing to do
}
