#include "Global.h"

/*
    return IPAddress, form a string in the format : ppp.qqq.rrr.sss
*/
void IpParse(char *a, int i[])
{
    int n=0, j;
    char c[4];
    
    i[0] = i[1] = i[2] = i[3] = 0;
    
    for(n=0;n<4;n++)
    {
        while(*a && (*a < '0' || *a > '9'))
            a++;
        j=0;
        while(*a && *a >= '0' && *a <= '9')
        {
            if(j< 3)
                c[j++] = *a;
            a++;
        }
        c[j] = 0;
        i[n] = atoi(c);
    }   
}

GlobalConfig::GlobalConfig(const std::string& filename)
{
    char *file = new char[filename.size()+1];
    strcpy(file, filename.c_str());
    printf("\r\n Open config file : %s\r\n", file);
    
    ConfigFile cfg(file);
    if(!cfg.IsOpen())
    {
        printf("Config File does not exist, Using defaults\r\n");
    }
    
    // IP Settings
    cfg.Value("net.ip", ip, sizeof(ip), "192,168,0,111");
    cfg.Value("net.mask", nm, sizeof(nm), "255,255,255,0");
    cfg.Value("net.gateway", gw, sizeof(gw), "192.168.123.254");
    cfg.Value("net.dns", dns, sizeof(dns), "192.168.123.194");
    cfg.Value("net.port", &port, 69);
    cfg.Value("net.dncp", &dhcp, 0);
    
    // system   
    cfg.Value("sys.autohome", &autohome, 0);
    cfg.Value("sys.autozhome", &autozhome, 0);
    cfg.Value("sys.nodisplay", &nodisplay, 1);
    cfg.Value("sys.i2cbaud", &i2cbaud, 9600);
    cfg.Value("sys.cleandir", &cleandir, 1);
    
    // laser
    cfg.Value("laser.enable", lenable, 1);      // laser enable polarity[0/1]
    cfg.Value("laser.on", &lon, 1);             // laser on polarity [0/1]
    cfg.Value("laser.pwm_min", &pwmmin, 0);     // pwm at minimum power [0 .. 100]
    cfg.Value("laser.pwm_max", &pwmmax, 0);     // pwm at maximum power [0.. 100];
    cfg.Value("laser.pwm_freq", &pwmfreq, 20000);   // pwm frequency
    cfg.Value("sys.exhaustoffdelay", &exhaust_offdelay, 30);
    // how long to continue air assist/extract after job completion (secs)
    
    // rest position(after homing)
    cfg.Value("x.rest", &xrest, 0);
    cfg.Value("y.rest", &yrest, 0);
    cfg.Value("z.rest", &zrest, 0);
    cfg.Value("e.rest", &erest, 0);

    // homing direction
    cfg.Value("x.homedir", &xhomedir, 0);
    cfg.Value("y.homedir", &yhomedir, 0);
    cfg.Value("z.homedir", &zhomedir, 0);
    cfg.Value("e.homedir", &ehomedir, 0);
   
    // invert signal polarity for step/dir
    cfg.Value("x.invert", &xinv, 0);
    cfg.Value("y.invert", &yinv, 0);
    cfg.Value("z.invert", &zinv, 0);
    cfg.Value("e.invert", &einv, 0);

    // polarity for the home switchs
    cfg.Value("x.pol", &xpol, 0);
    cfg.Value("y.pol", &ypol, 0);
    cfg.Value("z.pol", &zpol, 0);
    cfg.Value("e.pol", &epol, 0);
    
    // steps per meter
    cfg.Value("x.scale", &xscale, 200000);
    cfg.Value("y.scale", &yscale, 200000);
    cfg.Value("z.scale", &zscale, 200000);
    cfg.Value("e.scale", &escale, 200000);
         
    // Maximum linear speed and max speed per axis[mm/sec]
    cfg.Value("x.speed", &xspeed, 100);
    cfg.Value("y.speed", &yspeed, 100);
    cfg.Value("z.speed", &zspeed, 100);
    cfg.Value("e.speed", &espeed, 100);
   
    // axis max acceleration[mm/sec^2]
    cfg.Value("x.accel", &xaccel, 2000);
    cfg.Value("y.accel", &yaccel, 2000);
    cfg.Value("z.accel", &zaccel, 2000);
    cfg.Value("e.accel", &eaccel, 2000);
    
    // max axis speed [mm/sec]
    // home positions [um]
    cfg.Value("x.home", &xhome, 0);
    cfg.Value("y.home", &yhome, 0);
    cfg.Value("z.home", &zhome, 100000);
    cfg.Value("e.home", &ehome, 0);
    
    // min and max [um]
    cfg.Value("x.max", &xmax, GlobalConfig::VERYLARGE);
    cfg.Value("y.max", &ymax, GlobalConfig::VERYLARGE);
    cfg.Value("z.max", &zmax, GlobalConfig::VERYLARGE);
    cfg.Value("e.max", &emax, GlobalConfig::VERYLARGE);
    
    cfg.Value("x.min", &xmin, GlobalConfig::MINUSVERYLARGE);
    cfg.Value("y.min", &ymin, GlobalConfig::MINUSVERYLARGE);
    cfg.Value("z.min", &zmin, GlobalConfig::MINUSVERYLARGE);
    cfg.Value("e.min", &emin, GlobalConfig::MINUSVERYLARGE);
    
    // motion settings: enable output state 
    cfg.Value("motion.homespeed", &homespeed, 10);      // speed during homing [usec/step]
    cfg.Value("motion.zhomespeed", &zhomespeed, 10);     // z-axis speed during homing [usec/step]
    cfg.Value("motion.speed", &speed, 100);             // max speed [mm/sec]
    cfg.Value("motion.enable", &enable, 0);             // enable output polarity [0/1]
    cfg.Value("motion.tolerance", &tolerance, 50);      // cornering tolerance [1/1000 units]
    
    cfg.Value("dir_us", &dir_us, 0);
    cfg.Value("pulse_us", &pulse_us, 0);
}

int GlobalConfig::BedHeight()
{
    int result = 0;
    if(ymax != (int)GlobalConfig::VERYLARGE) && ( ymin != (int)GlobalConfig::MINUSVERYLARGE))
    {
        result = ymax - ymin;
        if(result < 0)
            result = 0;
    }
    
    return result;
}   
