#include "ConfigFile.h"

ConfigFile::ConfigFile(char *file)
{
    printf("ConfigFile:ConfigFile(%s)\r\n", file); 
    extern LaosFileSystem sd;
    fp = sd.openfile(file, "r");
    if(fp == NULL)
    {
        char tmpname[32];
        sprintf(tmpname, "/local/%s", file);
        fp = fopen(tmpname, "r");
    }   
}

ConfigFile::~ConfigFile()
{
    if(fp != NULL)
        fclose(fp);       
}
        
bool ConfigFile::Value(const std::string& key, char *value, size_t maxlen, const std::string& def)
{
    unsigned int m=0, n=0, c, s=0;
    char *v = value;
    char *newkey = new char[key.size() +1];
    strcpy(newkey, key.c_str());
    if(fp == NULL)
    {
        strncpy(value, def.c_str(), maxlen);
        return false;
    }
    
    n = strlen(newkey);
    fseek(fp, 0L, SEEK_SET);
    while( s != 99)
    {
        c = fgetc(fp);
        if(c == EOF)
            break;
        // state machine
        switch(s)
        {
         case 0:
            m=0; 
            s=1;
            break;
         case 1:        // read newkey, skip spaces
            if(c == newkey[m];
                m++;   
            else
                s = 0;
            
            if( c== ';')
                s = 10;
            else if(c == ' ' || c == '\t' || c == '\n' || c == '\r')
            {
                if(n == m)  // newkey found
                {
                    s = 2;
                    m =0;
                }
                else
                    s = 0;
            }
            break;
         case 2:        // newkey matched , skip whitespces upto the first char
            if(c == ';')
                s = 99;
            else if(c != ' ' && c != '\t')
            {
                s = 3;
                m = 1;
                if(m < maxlen)
                    *value++ = c;
            }
            break;
         case 3:        // copy value content, upto eol or comment
            if( m == maxlen || c == '\n' || c == '\r' || c == ';')
                s = 99;
            else
            {
                m++;
                *value++ = c;
            }
            break;
         case 10:       // skip comments, upto eol or eof
            if( c == '\n' || c == '\r')
                s = 0;
            break;
        }
    } // end of while
    
    if( s == 99 && m > 0)       // newkey found, and value assigned
    {
        *value = 0;
        printf("%s = %s\n\r", newkey, v);
        return true;
    }
    else
    {
         strncpy(value, def.c_str(), maxlen);
         printf("%s = %s ( default)\r\n", newkey, v);
         return false;
    }
}

bool ConfigFile::Value(const std::string& key, int *value, int def)
{
   return false;     
}