#ifndef GLOBAL_H_
#define GLOBAL_H_

#include "mbed.h"
#include <string.h>
#include "configfile.h"

typedef char IPAddress[16];
void IpParse(char *a, int i[]);

// global configuration struct
class GlobalConfig
{
    public:
        enum{VERTLARGE = 0x7fffffff, MINUSVERYLARGE = 0x80000000};
        GlobalConfig(const std::string& filename);
        int BedHeight() const;
        
        IPAddress ip, gw, nm, dns;                      // IP, gateway, netmask, dns server
        int port, dhcp;                                 // network settings
        int enable;                                     // enable state(1 or 0)
        int autohome;                                   // automatically home the axis at startup
        int autozhome;                                  // automatically home the z axis as well
        int nodisplay;                                  // there is no display
        int cleandir;                                   // remove files from SD at startup
        int i2cbaud;                                    // i2c Baudrate
        int xmax, ymax, zmax, emax;                     // max value
        int xmin, ymin, zmin, emin;                     // min value
        int xpol, ypol, zpol, epol;                     // polarity for the home switchs
        int xinv, yinv, zinv, einv;                     // invert signal polarity for step/dir
        int xhome, yhome, zhome, ehome;                 // home position
        int xrest, yrest, zrest, erest;                 // rest position(moveto after job)
        int xhomedir, yhomedir, zhomedir, ehomedir;     // 
        int homespeed, zhomespeed;                      // speed used for homing[usec/step]
        int speed, xspeed, yspeed, zspeed, espeed;      // MAximum linear speed and max speed per axis[mm/sec]
        int accel;                                      // default acceleration[mm/sec^2]
        int xaccel, yaccel, zaccel, eaccel;             // axis max acceleration[mm/sec^2]
        int tolerance;                                  // corner tolerance[micrometer]
        int xscale;                                     // steps per meter
        int yscale;
        int zscale;
        int escale;
        int lenable, lon, pwmmin, pwmmax, pwmfreq;      // laser enable, laser on, pwm min/max[%], frequency[Hz]
        int exhaust, exhaust_offdelay;                  // How long to continue powering air
        int dir_us, pulse_us;                           // extra wait time for longer pulse/dir
        
        // Nozzle/exhaust after job has ended(seconds)
};

#ifndef __GIT_HASH
#define __GIT_HASH  ""
#endif

#define VERSION_STRING "\LCUTTER V0.3-" __GIT_HASH "\n" __DATE__ " " __TIME__


#endif