//Rik Van Dyck
//Dieter Van Olmen
//Project Embedded C
//18 december 2014 (eerste evaluatie)

#include "mbed.h"                           // libary mbed
#include "TextLCD.h"                        // libary LCD
#include "ds1307.h"                         // libary real time clock met IC DS1307
#include "Servo.h"                          // libary servo
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

EthernetNetIf eth(
IpAddr(192,168,1,2),                         //ipadress
IpAddr(255,255,255,0),                       //network mask
IpAddr(192,168,1,1),                         //gateway
IpAddr(192,168,1,1)                          //dns
);
HTTPServer svr;

AnalogIn LM35_1(p20);                       // analoge-ngang, temperatuursensor 1
AnalogIn LM35_2(p19);                       // analoge-ngang, temperatuursensor 2

InterruptIn button_up(p11);                 // interrupt-ingang, 
InterruptIn button_menu_back(p13);          // interrupt-ingang,

DigitalIn button_down(p12);                 // digitale-ingang,
DigitalIn button_enter(p14);                // digitale-ingang,

DigitalOut relais(p15);                     // dgitale-uitgang, 

PwmOut LEDrood(p23);                        // PWM-uitgang, 
PwmOut LEDgroen(p22);                       // PWM-uitgang, 
PwmOut LEDblauw(p21);                       // PWM-uitgang, 
PwmOut achtergrondverlichting(p24);         // PWM-uitgang, 

Servo myservo(p26);                         // servo-uitgang 

DS1307 my1307(p9,p10);                      // start DS1307 class and give it pins for connections of the DS1307 device

Serial pc(USBTX, USBRX);                    // tx, rx

TextLCD lcd(p7,p8,p30,p29,p28,p27);         // interrupt-uitgang 

// float variabelen
float temp1;
float temp2;
float temp1a;
float temp2a;
float avg1;
float avg2;
float instel_temp = 20.00;
float backup1 = 20.00;
float instel_temp_serieel;
float min_temp;
float max_temp;
float helderheid = 0.5;
float backup_h = 0;
float verschil;
float uitwijking;

// integer variabelen
int i;
int k = 0;
int m = 0;
int n = 40;
int y;
int z;
int status = 0;
int selectie = 1;
int wachttijd_menu = 0;
int wachttijd_klok = 0;
int wachttijd_up = 0;
int hysteresis = 0;

// variable voor de tijd (integers)
int sec;
int minu;
int hours;
int day;
int date;
int month;
int year;
int junk = 0;
int klok1_u = 6;
int klok2_u = 8;
int klok3_u = 15;
int klok4_u = 22;
int klok1_m = 30;
int klok2_m = 30;
int klok3_m = 30;
int klok4_m = 00;
int backup_klok1_u;
int backup_klok2_u;
int backup_klok3_u;
int backup_klok4_u;
int backup_klok1_m;
int backup_klok2_m;
int backup_klok3_m;
int backup_klok4_m;

void up();
void down();
void menu();
void controle();
void temp_inlezen();
void serieel_printen();
void lcd_printen_temp();
void RTC_junk();
void internet();

void test_rw(int test) {} 

int main()
{   

    EthernetErr ethErr;
    int count = 0;
    do {
        printf("Setting up %d...\n\r", ++count);
        ethErr = eth.setup();
        if (ethErr) printf("Timeout\n\r", ethErr);
    } while (ethErr != ETH_OK);

    printf("Connected OK\n\r");
    const char* hwAddr = eth.getHwAddr();

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\n\r", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);

    LocalFileSystem local("local");

    //svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<FSHandler>("");

    svr.bind(80);
    printf("Server listening\n\r");

    //int junk = 0;
    LEDrood = 0;
    LEDblauw = 0;
    LEDgroen = 0;
    myservo = 0.5;
    button_up.mode(PullDown);
    button_down.mode(PullDown);
    button_menu_back.mode(PullDown);
    button_enter.mode(PullDown);
    button_up.rise(&up);
    button_menu_back.rise(&menu);
    achtergrondverlichting = helderheid;
    pc.printf("Temperatuursmeting Embed !!");
    pc.printf("\n\n\r");
    instel_temp_serieel = instel_temp;
    while (1) {
        serieel_printen();
        controle();
        lcd_printen_temp();
    }
}

void RTC_junk()
{
    junk = 0x39;                                    // just a junk value do read and write test to DS1307 ram
    test_rw(my1307.write( 0x20, junk));             // this should write the value of junk to register 0x20 (a ram location) in the ds1307.
    junk = 0;                                       // clear junk to show that when the register is read from the correct value is obtained
    test_rw(my1307.read( 0x20, &junk));             // this should read register 0x20
}

void temp_inlezen()
{
    avg1 = 0;
    avg2 = 0;
    for (i = 0; i < 100; i++ ) {
        avg1 += LM35_1;
        avg2 += LM35_2;
        wait(0.001);
    }
    temp1 =(avg1 * 3.3);
    temp2 =(avg2 * 3.3); 
}

void internet()
{            
        Net::poll();
            FILE *fp = fopen("/local/mydata.htm","w");
            fprintf(fp,"<HTML>\r\n");
            fprintf(fp,"<HEAD>\r\n");
            fprintf(fp,"</HEAD>\r\n");
            fprintf(fp,"<BODY>\r\n");
            fprintf(fp," <center><p><h1>Welcome to Thomas More  </h1></p>\r\n");
            fprintf(fp," <center><p><h1>2EA</h1></p>\r\n");
            fprintf(fp," <body style=background-color:white>\r\n");
            fprintf(fp," <hr><br> <h1 align=left><font color=\"black\">\r\n");
            fprintf(fp," <left><FONT size=+1><h1>Project Embedded C</h1>\r\n");
            fprintf(fp," <TABLE width=500 bgcolor=white border=2 >\r\n");
            fprintf(fp," <TR>\r\n");
            fprintf(fp," <TD align=center colspan=4 bgcolor=red><B><FONT size=+2>Mbed temperatuurregeling</FONT></B></TD></TR>\r\n");
            fprintf(fp," <TR>\r\n");
            fprintf(fp," <TD align=center width=125 colspan=1><B>Binnen</B></TD>\r\n");
            fprintf(fp," <TD align=center width=125 colspan=1><B>Buiten</B></TD>\r\n");
            fprintf(fp," <TD align=center width=125 colspan=1><B>ingesteld</B></TD>\r\n");
            fprintf(fp," <TD align=center width=125 colspan=1><B>Tijd</B></TD>\r\n");
            fprintf(fp," <TR align=center>\r\n");
            fprintf(fp," <TD ><U>%.2f</U>\r\n",temp1);
            fprintf(fp," <TD ><U>%.2f</U>\r\n",temp2);
            fprintf(fp," <TD ><U>%.2f</U>\r\n",instel_temp);
            fprintf(fp," <TD ><U>%d:%d:%d</U>\r\n",hours,minu,sec);
            fprintf(fp," <TR align=center>");      
            fprintf(fp," \r\n");
            fprintf(fp,"</BODY>\r\n");
            fprintf(fp,"</HTML>\r\n");
            fclose(fp);
}

void controle()
{
    temp_inlezen();
    if(selectie == 3)
    {
        if(hours >= klok1_u && minu >= klok1_m && hours <= klok2_u && minu < klok2_m)
        {
            if(m == 0)
            {
                min_temp = instel_temp - 0.5;
                max_temp = instel_temp + 0.5;
                if (temp1 < min_temp)
                {
                    LEDrood = 1;
                    LEDgroen = 0;
                    LEDblauw = 0;
                    relais = 0;
                    status = 1;   
                }
                else if (temp1 > max_temp)
                {
                    LEDrood = 0;
                    LEDgroen = 0;
                    LEDblauw = 0.25;
                    relais = 1;
                    status = 0; 
                }
                else{}
            }
            m++;
            if(m > 15){m = 0;}   
        }
        else if(hours >= klok3_u && minu >= klok3_m && hours <= klok4_u && minu < klok4_m)
        {
            if(m == 0)
            {
                min_temp = instel_temp - 0.5;
                max_temp = instel_temp + 0.5;
                if (temp1 < min_temp)
                {
                    LEDrood = 1;
                    LEDgroen = 0;
                    LEDblauw = 0;
                    relais = 0;
                    status = 1;   
                }
                else if (temp1 > max_temp)
                {
                    LEDrood = 0;
                    LEDgroen = 0;
                    LEDblauw = 0.25;
                    relais = 1;
                    status = 0; 
                }
                else{}
            }
            m++;
            if(m > 15){m = 0;}   
        }
        else
        {   
            if(m == 0)
            {
                min_temp = 18.0 - 0.5;
                max_temp = 18.0 + 0.5;
                if (temp1 < min_temp)
                {
                    LEDrood = 1;
                    LEDgroen = 0;
                    LEDblauw = 0;
                    relais = 0;
                    status = 1;   
                }
                else if (temp1 > max_temp)
                {
                    LEDrood = 0;
                    LEDgroen = 0;
                    LEDblauw = 0.25;
                    relais = 1;
                    status = 0; 
                }
                else{}
            }
            m++;
            if(m > 15){m = 0;}     
        } 
    }
    else
    {
        if(m == 0)
        {
            min_temp = instel_temp - 0.5;
            max_temp = instel_temp + 0.5;
            if (temp1 < min_temp)
            {
                LEDrood = 1;
                LEDgroen = 0;
                LEDblauw = 0;
                relais = 1;
                status = 1;   
            }
            else if (temp1 > max_temp)
            {
                LEDrood = 0;
                LEDgroen = 0;
                LEDblauw = 0.25;
                relais = 0;
                status = 0; 
            }
            else{}
        }
    }
    verschil = temp1 - instel_temp;
    if(verschil > 0)
    {
        uitwijking = verschil / 10;
        if(uitwijking > 0.5)
        {
            uitwijking = 0.5;
        }
        uitwijking = uitwijking + 0.5;
    }
    if(verschil < 0)
    {   
        verschil = instel_temp - temp1;
        uitwijking = verschil / 10;
        if(uitwijking > 0.5)
        {
            uitwijking = 0.5;
        }
        uitwijking = 0.5 - uitwijking;
    }
    if(verschil == 0)
    {
        uitwijking = 0.5;
    }
    myservo = uitwijking;
    m++;
    if(m > 15){m = 0;}
}

void serieel_printen()
{
    pc.printf("Tijd:");
    pc.printf("\n\n\r");
    pc.printf("Binnen temperatuur: %.2fC",temp1);
    pc.printf("\n\r");
    pc.printf("Buiten temperatuur: %.2fC",temp2);
    pc.printf("\n\r");
    pc.printf("Instel temperatuur: %.2fC",instel_temp_serieel);
    pc.printf("\n\n\n\r");
}

void lcd_printen_temp()
{
    if (k == 1 || k > 7){
        temp1a = temp1;
        temp2a = temp2;
        wachttijd_menu = 0;
        wachttijd_klok = 0;
        wachttijd_up = 0; 
    }
    if(k < 7) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Binnen:%5.1f%cC", temp1a,0xDF);
        lcd.locate(0,1);
        lcd.printf("Buiten:%5.1f%cC", temp2a,0xDF);
        k++;
    } else if(k < 14) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Instel:%5.1f%cC",instel_temp,0xDF);
        lcd.locate(0,1);
        test_rw(my1307.gettime( &sec, &minu, &hours, &day, &date, &month, &year));
        lcd.printf("Tijd:   %d:%d:%d",hours,minu,sec);
        RTC_junk();
        k++;
    } else if(k < 21) {
        lcd.cls();
        lcd.locate(0,0);
        switch (selectie) {
            case (1):
                lcd.printf("Stand: Continu");
                break;
            case (2):
                lcd.printf("Stand: Nacht");
                break;
            case (3):
                lcd.printf("Stand: Klokje");
                break;
        }
        lcd.locate(0,1);
        switch (status) {
            case (0):
                lcd.printf("Status: Af");
                break;
            case (1):
                lcd.printf("Status: Op");
                break;
        }
        k++;
    } else {
        k = 0;
    }
    internet();
}

void menu()
{
    if(wachttijd_up < 10 && wachttijd_menu < 10) {
        wachttijd_menu = 0;
        z = 0;
        wait(0.5);
        while(button_enter == 0 && button_menu_back == 0 && wachttijd_menu < n) {
            controle();
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("** Menu **");
            if (button_up == 1) {
                z++;
                wachttijd_menu = 0;
            } else if(button_down == 1) {
                z--;
                wachttijd_menu = 0;
            } else {
                wachttijd_menu++;
            }
            if (z > 3){
                z = 0;
            }
            if (z < 0) {
                z = 3;
            }
            if (z == 0) {
                lcd.locate(0,1);
                lcd.printf("Continu");
            } else if (z == 1) {
                lcd.locate(0,1);
                lcd.printf("Nacht");
            } else if (z == 2) {
                lcd.locate(0,1);
                lcd.printf("Klokje");
            } else if (z == 3) {
                lcd.locate(0,1);
                lcd.printf("Helderheid");
            }
            lcd.locate(14,1);
            lcd.printf("<");
            lcd.locate(15,1);
            lcd.printf(">");
        }
        if (button_enter == 1) {
            switch (z) {
                case (0):
                    if (selectie == 2)
                    {
                        instel_temp = backup1;
                    }
                    selectie = 1;
                    break;
                case (1):
                    selectie = 2;
                    backup1 = instel_temp;
                    instel_temp = 18.00;
                    break;
                case (2):
                    if (selectie == 2)
                    {
                        instel_temp = backup1;
                    }
                    //
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Instelling tijd");
                    wait(1);
                    backup_klok1_u = klok1_u;
                    backup_klok2_u = klok2_u;
                    backup_klok3_u = klok3_u;
                    backup_klok4_u = klok4_u;
                    backup_klok1_m = klok1_m;
                    backup_klok2_m = klok2_m;
                    backup_klok3_m = klok3_m;
                    backup_klok4_m = klok4_m;
                    lcd.cls();
                    wachttijd_klok = 0;
                    while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                        controle();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("'S morgens op  u");
                        if(button_up == 1)
                        {
                            klok1_u = klok1_u + 1;
                            wachttijd_klok = 0;
                        }
                        else if(button_down == 1)
                        {
                            klok1_u = klok1_u - 1;
                            wachttijd_klok = 0;
                        }
                        else
                        {
                            wachttijd_klok ++;
                        }
                        if (klok1_u > 23)
                        {
                            klok1_u = 0;
                        }
                        if (klok1_u < 0)
                        {
                            klok1_u = 23;
                        }
                        lcd.locate(0,1);
                        lcd.printf("Tijd:   %d:%d",klok1_u,klok1_m);
                    }
                    if (button_enter == 1)
                    {
                        wachttijd_klok = 0;
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("'S morgens op  m");
                        wait(0.5);
                        while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                            controle();
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("'S morgens op  m");
                            if(button_up == 1)
                            {
                                klok1_m = klok1_m + 1;
                                wachttijd_klok = 0;
                            }
                            else if(button_down == 1)
                            {
                                klok1_m = klok1_m - 1;
                                wachttijd_klok = 0;
                            }
                            else
                            {
                                wachttijd_klok ++;
                            }
                            if (klok1_m > 60)
                            {
                                klok1_m = 0;
                            }
                            if (klok1_m < 0)
                            {
                                klok1_m = 59;
                            }
                            lcd.locate(0,1);
                            lcd.printf("Tijd:   %d:%d",klok1_u,klok1_m);
                        }
                        if (button_enter == 1)
                        {
                            wachttijd_klok = 0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("'S morgens af  u");
                            wait(0.5);
                            while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                controle();
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("'S morgens af  u");
                                if(button_up == 1)
                                {
                                    klok2_u = klok2_u + 1;
                                    wachttijd_klok = 0;
                                }
                                else if(button_down == 1)
                                {
                                    klok2_u = klok2_u - 1;
                                    wachttijd_klok = 0;
                                }
                                else
                                {
                                    wachttijd_klok ++;
                                }
                                if (klok2_u > 60)
                                {
                                    klok2_u = 0;
                                }
                                if (klok2_u < 0)
                                {
                                    klok2_u = 59;
                                }
                                lcd.locate(0,1);
                                lcd.printf("Tijd:   %d:%d",klok2_u,klok2_m);
                            }
                            if (button_enter == 1)
                            {
                                wachttijd_klok = 0;
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("'S morgens af  m");
                                wait(0.5);
                                while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                    controle();
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("'S morgens af  m");
                                    if(button_up == 1)
                                    {
                                        klok2_m = klok2_m + 1;
                                        wachttijd_klok = 0;
                                    }
                                    else if(button_down == 1)
                                    {
                                        klok2_m = klok2_m - 1;
                                        wachttijd_klok = 0;
                                    }
                                    else
                                    {
                                        wachttijd_klok ++;
                                    }
                                    if (klok2_m > 60)
                                    {
                                        klok2_m = 0;
                                    }
                                    if (klok2_m < 0)
                                    {
                                        klok2_m = 59;
                                    }
                                    lcd.locate(0,1);
                                    lcd.printf("Tijd:   %d:%d",klok2_u,klok2_m);
                                }
                                if (button_enter == 1)
                                {
                                    wachttijd_klok = 0;
                                    lcd.cls();
                                    lcd.locate(0,0);
                                    lcd.printf("'S avonds op   u");
                                    wait(0.5);
                                    while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                        controle();
                                        lcd.cls();
                                        lcd.locate(0,0);
                                        lcd.printf("'S avonds op   u");
                                        if(button_up == 1)
                                        {
                                            klok3_u = klok3_u + 1;
                                            wachttijd_klok = 0;
                                        }
                                        else if(button_down == 1)
                                        {
                                            klok3_u = klok3_u - 1;
                                            wachttijd_klok = 0;
                                        }
                                        else
                                        {
                                            wachttijd_klok ++;
                                        }
                                        if (klok3_u > 60)
                                        {
                                            klok3_u = 0;
                                        }
                                        if (klok3_u < 0)
                                        {
                                            klok3_u = 59;
                                        }
                                        lcd.locate(0,1);
                                        lcd.printf("Tijd:   %d:%d",klok3_u,klok3_m);
                                    }
                                    if (button_enter == 1)
                                    {
                                        wachttijd_klok = 0;
                                        lcd.cls();
                                        lcd.locate(0,0);
                                        lcd.printf("'S avonds op   m");
                                        wait(0.5);
                                        while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                            controle();
                                            lcd.cls();
                                            lcd.locate(0,0);
                                            lcd.printf("'S avonds op   m");
                                            if(button_up == 1)
                                            {
                                                klok3_m = klok3_m + 1;
                                                wachttijd_klok = 0;
                                            }
                                            else if(button_down == 1)
                                            {
                                                klok3_m = klok3_m - 1;
                                                wachttijd_klok = 0;
                                            }
                                            else
                                            {
                                                wachttijd_klok ++;
                                            }
                                            if (klok3_m > 60)
                                            {
                                                klok3_m = 0;
                                            }
                                            if (klok3_m < 0)
                                            {
                                                klok3_m = 59;
                                            }
                                            lcd.locate(0,1);
                                            lcd.printf("Tijd:   %d:%d",klok3_u,klok3_m);
                                        }
                                        if (button_enter == 1)
                                        {
                                            wachttijd_klok = 0;
                                            lcd.cls();
                                            lcd.locate(0,0);
                                            lcd.printf("'S avonds af   u");
                                            wait(0.5);
                                            while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                                controle();
                                                lcd.cls();
                                                lcd.locate(0,0);
                                                lcd.printf("'S avonds af   u");
                                                if(button_up == 1)
                                                {
                                                    klok4_u = klok4_u + 1;
                                                    wachttijd_klok = 0;
                                                }
                                                else if(button_down == 1)
                                                {
                                                    klok4_u = klok4_u - 1;
                                                    wachttijd_klok = 0;
                                                }
                                                else
                                                {
                                                    wachttijd_klok ++;
                                                }
                                                if (klok4_u > 60)
                                                {
                                                    klok4_u = 0;
                                                }
                                                if (klok4_u < 0)
                                                {
                                                    klok4_u = 59;
                                                }
                                                lcd.locate(0,1);
                                                lcd.printf("Tijd:   %d:%d",klok4_u,klok4_m);
                                            }
                                            if (button_enter == 1)
                                            {   
                                                wachttijd_klok = 0;
                                                lcd.cls();
                                                lcd.locate(0,0);
                                                lcd.printf("'S avonds af   m");
                                                wait(0.5);
                                                while (button_enter == 0 && button_menu_back == 0 && wachttijd_klok < n) {
                                                    controle();
                                                    lcd.cls();
                                                    lcd.locate(0,0);
                                                    lcd.printf("'S avonds af   m");
                                                    if(button_up == 1)
                                                    {
                                                        klok4_m = klok4_m + 1;
                                                        wachttijd_klok = 0;
                                                    }
                                                    else if(button_down == 1)
                                                    {
                                                        klok4_m = klok4_m - 1;
                                                        wachttijd_klok = 0;
                                                    }
                                                    else
                                                    {
                                                        wachttijd_klok ++;
                                                    }
                                                    if (klok4_m > 60)
                                                    {
                                                        klok4_m = 0;
                                                    }
                                                    if (klok4_m < 0)
                                                    {
                                                        klok4_m = 59;
                                                    }
                                                    lcd.locate(0,1);
                                                    lcd.printf("Tijd:   %d:%d",klok4_u,klok4_m);
                                                }
                                                if (button_enter == 1)
                                                {
                                                    selectie = 3;  
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if(button_menu_back == 1 || wachttijd_klok > n)
                    {
                        klok1_u = backup_klok1_u;
                        klok2_u = backup_klok2_u;
                        klok3_u = backup_klok3_u;
                        klok4_u = backup_klok4_u;
                        klok1_m = backup_klok1_m;
                        klok2_m = backup_klok2_m;
                        klok3_m = backup_klok3_m;
                        klok4_m = backup_klok4_m;
                    }                 
                    break;
                case (3):
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Helderheid");
                    wait(0.5);
                    backup_h = helderheid;
                    lcd.cls();
                    wachttijd_menu = 0;
                    while (button_enter == 0 && button_menu_back == 0 && wachttijd_menu < n) {
                        controle();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Helderheid");
                        if(button_up == 1) {
                            helderheid = helderheid + 0.1;
                            wachttijd_menu = 0;
                        } else if(button_down == 1) {
                            helderheid = helderheid - 0.1;
                            wachttijd_menu = 0;
                        } else {
                            wachttijd_menu ++;
                        }
                        if (helderheid > 1.1) {
                            helderheid = 0;
                        }
                        if (helderheid < 0) {
                            helderheid = 1;
                        }
                        lcd.locate(0,1);
                        lcd.printf("=> %.1f",helderheid);
                        achtergrondverlichting = helderheid;
                    }
                    if (button_menu_back == 1) {
                        helderheid = backup_h;
                    }
                    achtergrondverlichting = helderheid;
                    break;
            }
        }
    }
    wachttijd_menu = 20;
    wachttijd_klok = 20;
    wachttijd_up = 0;
    k = 0;
}

void up()
{
    if((selectie == 1 || selectie == 3) && wachttijd_menu < 10 && wachttijd_klok < 10 && wachttijd_up < 10) {
        backup1 = instel_temp;
        lcd.cls();
        wachttijd_up = 0;
        while (button_enter == 0 && button_menu_back == 0 && wachttijd_up < n) {
            controle();
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Instel: %.2f C",instel_temp);
            if(button_up == 1) {
                instel_temp = instel_temp + 0.5;
                wachttijd_up = 0;
            } else if(button_down == 1) {
                instel_temp = instel_temp - 0.5;
                wachttijd_up = 0;
            } else {
                wachttijd_up ++;
            }
        }
        if (button_enter == 1) {
            instel_temp = instel_temp;
            instel_temp_serieel = instel_temp;
            wachttijd_up = 0;
        } else if (button_menu_back == 1) {
            instel_temp = backup1;
            instel_temp_serieel = backup1;
            wachttijd_up = 20;
        } else {
            instel_temp = backup1;
            instel_temp_serieel = backup1;
        }
        serieel_printen();
    }
    wachttijd_menu = 0;
    wachttijd_klok = 0;
    wachttijd_up = 20;
    k = 0;
}