#include "servo_and_movefunc.h"
#include "pi.h"
#include "math.h"
#include "debug.h"
#ifndef VSCODE
#include "KondoServo.h"
#include "pinnames.h"
#include "can.h"
#include "hcsr04.h"
#define USE_CAN //can通信するならdefine.しないなら切らないとエラー出る
#endif
FILE *fp;
const float kRadToDegree = 180.0 / M_PI;
//サーボの送信間隔
const int kServoSpan_ms = 6;
//サーボの正負と座標系の正負の補正.足で一セット。
const int kServoSign[2][2] = {{-1, -1}, {-1, -1}};
//欲しい座標系0度でのサーボのICSマネージャーの値
const double kServoValToDegree = 270.0 / (11500 - 3500); //ICSの値を度に変換
const double kOriginDegree[2][2] = {
    {
        (7268 - 3500) * kServoValToDegree,
        (7768 - 3500) * kServoValToDegree + 180,
    },
    {
        (7467 - 3500) * kServoValToDegree,
        (7543 - 3500) * kServoValToDegree + 180,
    },
};
#ifndef VSCODE
Timer timer;
KondoServo servo[2] = {
    KondoServo(pin_serial_servo_tx[0], pin_serial_servo_rx[0]),
    KondoServo(pin_serial_servo_tx[1], pin_serial_servo_rx[1]),
};
DigitalOut led[4] = {DigitalOut(LED1), DigitalOut(LED2), DigitalOut(LED3), DigitalOut(LED4)};
HCSR04 usensor(p25, p24); // Trigger(DO), Echo(PWMIN)
#endif
//一サイクル分進む.return 1:異常終了
int MoveOneCycle(Walk walkway, OneLeg leg[4])
{
#ifndef VSCODE
    timer.reset();
    timer.start();
#endif
    int count = walkway.orbit[0].GetOneWalkTime() / walkway.calctime_s_;
    for (int i = 0; i < count; i++)
    {
#ifndef VSCODE
        float time_s = timer.read();
#endif
        //4本の足それぞれの足先サーボ角度更新
        if (walkway.Cal4LegsPosi(leg) == 1)
        {
            printf("error: time = %f\r\n", i * walkway.calctime_s_);
            return 1;
        }
#ifdef USE_CAN
        SendRad(leg[2], leg[3]); //slave_mbed分の足の目標位置を送信
#endif
        //自身が動かす足のサーボを動かす
        MoveServo(leg[0], 0, 0);
        MoveServo(leg[1], 1, 0);
#ifndef VSCODE
        wait_ms(kServoSpan_ms);
#endif
        MoveServo(leg[0], 0, 1);
        MoveServo(leg[1], 1, 1);
#ifdef VSCODE
        //ファイルに書き込み。time[s],x[0],y[0],x[1],y[1],x[2],y[2],x[3],y[3]の順
        fprintf(fp, "%f", i * walkway.calctime_s_);
        for (int i = 0; i < 4; i++)
            fprintf(fp, ",%f,%f", leg[i].GetX_m(), leg[i].GetY_m());
        fprintf(fp, "\r\n");
#else
        //計算周期がwalkway.calctime_s_になるようwait
        float rest_time_s = walkway.calctime_s_ - (timer.read() - time_s);
        if (rest_time_s > 0)
            wait(rest_time_s);
        else
        { //計算周期が達成できないときはDEBUGで知らせるだけ。動きはする。
            DEBUG("error: rest_time_s = %f in Move()\r\n", rest_time_s);
            led[0] = 1;
        }
#endif
    }
    return 0;
}
void MoveServo(OneLeg leg, int serial_num, int servo_id)
{
#ifndef VSCODE
    float degree = leg.GetRad(servo_id) * kRadToDegree;
    //サーボの座標系に変更
    float servo_degree = kServoSign[serial_num][servo_id] * degree + kOriginDegree[serial_num][servo_id];
    //    DEBUG("servo_degree[%d][%d],%f\r\n", serial_num, servo_id, servo_degree);
    servo[serial_num].set_degree(servo_id, servo_degree);
#endif
}
void WaitStdin(char startchar)
{
    char str[255] = {};
    do
    {
        printf("put '%c', then start\r\n", startchar);
        scanf("%s", str);
    } while (str[0] != startchar);
}

int FileOpen() //1:異常終了
{
    if ((fp = fopen("data.csv", "w")) == NULL)
    {
        printf("error : FileSave()\r\n");
        return 1;
    }
    fprintf(fp, "time[s],x[0],y[0],x[1],y[1],x[2],y[2],x[3],y[3]\r\n");
    return 0;
}
unsigned int GetDist_cm()
{
    usensor.start();
    return usensor.get_dist_cm();
}