#include "can.h"
#include "mbed.h"
#include "nhk19mr2_can_info.h"
#include "pinnames.h"
#include "splitData.h"
CAN can(pin_can_rd, pin_can_td);

void MakeCanRad(OneLeg leg0, OneLeg leg1, char *candata);
void SendRad(OneLeg leg0, OneLeg leg1)
{
    char candata[kByteEachRad * 4] = {};
    MakeCanRad(leg0, leg1, candata);
    CANMessage msg(CANID_SERVO_RAD, candata, kByteCanSevoRad);
    can.write(msg);
}
void MakeCanRad(OneLeg leg0, OneLeg leg1, char *candata)
{
    float rad[4] = {
        leg0.GetRad(0),
        leg0.GetRad(1),
        leg1.GetRad(0),
        leg1.GetRad(1),
    };
    int rad_multi[4];
    for (int i = 0; i < 4; i++)
    {
        rad_multi[i] = rad[i] * kRadToData;
        Intobyte(rad_multi[i], kByteEachRad, candata, i * kByteEachRad);
    }
}