#ifndef INCLUDED_TRIANGLE_H
#define INCLUDED_TRIANGLE_H
#include "OneLeg.h"
enum TriangleParams
{
    OFFSET_X_M,
    OFFSET_Y_M,
    STRIDE_M,
    HEIGHT_M,
    BUFFER_HEIGHT_M,
};
//下記の論文を参照
//https://static1.squarespace.com/static/542ddec8e4b0158794bd1036/t/5a861d1cc83025f3d460dfc3/1518738728029/gait-design-optimization-Final.pdf
class Triangle
{
  protected:
    float beta_degree_; //論文のβ
    float offset_x_m_;
    float offset_y_m_;
    float stride_m_;
    float height_m_;        //足上げ幅
    float buffer_height_m_; //着地直前で止める高さ
    float stridetime_s_;
    float toptime_s_;     //頂点に行くまでの時間
    float buffer_time_s_; //一時停止点から着地するまでの時間.

    float reverse_tanbeta_;                               //論文のβのtan
    float top_x_m_, top_y_m_, buffer_x_m_, buffer_y_m_;   //事前に計算して保存しておく
    int StrideLine_(OneLeg &leg, float phasetime_s);      //着地している間の軌道
    int StrideLineAccel_(OneLeg &leg, float phasetime_s); //着地中に慣性力を考慮して加減速

  public:
    void CalOtherParam();
    void SetTriangleParam(float offset_x_m, float offset_y_m, float stride_m, float height_m, float buffer_height_m,
                          float stridetime_s, float toptime_s, float buffer_time_s);
    int GetOrbit(OneLeg &leg, float phasetime_s);
    float GetOneWalkTime(); //足一周の時間
    void ChangeOneParam(TriangleParams param, float val);
    void Copy(const Triangle &origin);
};

class FourPoint : public Triangle
{
    void CalOtherParam();

  public:
    void SetFourPointParam(float offset_x_m, float offset_y_m, float stride_m, float height_m, float buffer_height_m,
                           float stridetime_s, float toptime_s, float buffer_time_s);
};
#endif