#ifndef INCLUDED_ORBIT_H
#define INCLUDED_ORBIT_H
#include "freeline.h"
#include "triangle.h"
enum OrbitPattern
{
    TRIANGLE,
    FREELINES,
    FOURPOINT,
};
//足の軌道を設定するクラスの皮。全ての軌道クラスを継承して一つにまとめる。patternで使い分ける
//関数は継承元のものを使うので、継承元のクラスも見てください
//名前が被っているものはpatternでswitchすることで決定する。
class Orbit : public FreeLines, public FourPoint
{
  public:
    Orbit(){}; //ただ宣言する用
    Orbit(OrbitPattern pattern);
    float GetOneWalkTime();                       //足一周の時間
    int GetOrbit(OneLeg &leg, float phasetime_s); //legに目標x,yを代入
    void Copy(const Orbit &origin);

  private:
    OrbitPattern pattern_;
};
#endif