#include "orbit.h"

Orbit::Orbit(OrbitPattern pattern)
{
    pattern_ = pattern;
}
float Orbit::GetOneWalkTime()
{
    float time_s;
    switch (pattern_)
    {
    case FREELINES:
        time_s = FreeLines::GetOneWalkTime();
        break;
    case FOURPOINT:
        time_s = FourPoint::GetOneWalkTime();
        break;
    default:
        time_s = Triangle::GetOneWalkTime();
        break;
    }
    return time_s;
}
int Orbit::GetOrbit(OneLeg &leg, float phasetime_s)
{
    int ret;
    switch (pattern_)
    {
    case FREELINES:
        ret = FreeLines::GetOrbit(leg, phasetime_s);
        break;
    case FOURPOINT:
        ret = FourPoint::GetOrbit(leg, phasetime_s);
        break;
    default:
        ret = Triangle::GetOrbit(leg, phasetime_s);
        break;
    }
    return ret;
}
void Orbit::Copy(const Orbit &origin)
{
    pattern_ = origin.pattern_;
    switch (pattern_)
    {
    case FREELINES:
        FreeLines::Copy((FreeLines)origin);
        break;
    case FOURPOINT:
        FourPoint::Copy((FourPoint)origin);
        break;
    default:
        Triangle::Copy((Triangle)origin);
        break;
    }
}