#ifndef INCLUDED_FREELINE_H
#define INCLUDED_FREELINE_H
#include "OneLeg.h"
struct LineParam
{
  float time_s;   //x_m,y_mにいる時間
  float x_m;
  float y_m;
  int is_point_to_point; //前の点からこの点まで、最短で経過するなら1,直線を維持するなら0
};
//複数の直線で軌道構成.理論もへったくれもなく自由に線を書く
class FreeLines
{
public:
  void SetFreeLinesParam(LineParam lineparams[], int point_num); //任意の直線の軌道を設定
  int GetOrbit(OneLeg &leg, float phasetime_s);
  float GetOneWalkTime(); //足一周の時間
  void Copy(const FreeLines &origin);
  LineParam lineparams_[20]; //pointの数は多めにとっている。
  int point_num_;            //pointの数
};

#endif