#ifndef INCLUDED_OVERCOME_H
#define INCLUDED_OVERCOME_H
#include "Walk.h"
enum LegNum //足とシリアルサーボの番号
{
  RIGHT_B,
  RIGHT_F,
  LEFT_B,
  LEFT_F,
};
class OverCome
{
  float start_x_m_[4]; //足のスタートx
  float start_y_m_[4]; //足のスタートy
  float d_x_m_;        //目標地点までのx
  float goal_y_m_[4];  //目標地点までのy
  float height_m_[4];
  float gravity_dist_[4]; //重心ずらし距離
  float d_time_;          //各動きの時間
  float d_time_slow_;
  float raise_offset_x_m_[4]; //raiseするときにずらすx_m
  int next_point_;            //次のparamのindex
  LineParam legs_[4][30];     //多めに
  void Rise(int legnum);
  void Land(int legnum);
  void Forward(int legnum);
  void Step(int legnum);
  void GravityMove(int legnum);
  void StartPoint();
  void GoalPoint();
  void GetLine();

public:
  Walk walk;
  OverCome(float start_x_m[4], float start_y_m[4],
           float d_x_m, float goal_y_m[4], float height_m[4], float gravity_dist[4],
           OneLeg legs[4], float raise_offset_x_m[4], float d_time, float d_time_slow);
};
#endif