#ifndef __KONDO_SERVO_H__
#define __KONDO_SERVO_H__

#include "mbed.h"
#include "SerialHalfDuplex.h"

typedef enum ServoMode{single = 0,multi = 1}s_mode;
typedef unsigned char u8;

class KondoServo{
    protected:
        unsigned int baudrate;
        s_mode mode; 
        SerialHalfDuplex master;

    public:        
        void init(int baud);
        void init();
        
        void setSpeed(int id, u8 speed);
        float readSpeed(int id);
        int set_degree(int id,float degree);
        void setID(u8 id);
        u8 readID();
        ~KondoServo();
        KondoServo(PinName txPin,PinName rxPin, int quantity=2, unsigned int baud=115200);

};
#endif