 #include "mbed.h"
#include "SWSPI.h"

SWSPI spi( PA_2, PA_1, PA_3 );              // create the SPI port
DigitalOut OE(PA_0);
DigitalOut LE(PA_4);                                    // the LE pin and the number of connected chips
DigitalIn B1(PA_5), B2(PA_6), B3(PA_7), B4(PB_1);       //B1 is the most left button
BusIn buttons(PA_5, PA_6, PA_7, PB_1);
const uint8_t numbers[10] = {0x7B, 0x60, 0x57, 0x76, 0x6C, 0x3E, 0x3F, 0x70, 0x7F, 0x7E};
uint8_t flip = 1;

uint8_t SetSysClock_PLL_HSE_16M(void);

RTC_HandleTypeDef hrtc;
HAL_StatusTypeDef status;
void SystemClock_Config(void);
static void MX_RTC_Init(void);

typedef struct
    {
        uint8_t second_right;
        uint8_t second_left;
        uint8_t minute_right;
        uint8_t minute_left;
        uint8_t hour_right;
        uint8_t hour_left;
    }clock_typ; 

struct tm t;
time_t rawtime;
clock_typ numiclock;
Ticker secondticker; 
void secondtick(void); 
void updatetime(void);
int main() 
{
    MX_RTC_Init();
    static struct tm *t3;
    buttons.mode(PullUp);

    LE = 0;
    OE = 1;

    t.tm_sec = 0;
    t.tm_min = 0;
    t.tm_hour = 0;
    t.tm_mday = 1;
    t.tm_mon = 1-1;
    t.tm_year = 2016-1900;
    set_time(mktime(&t));

    rawtime = time(NULL);

    spi.write(0x00);
    spi.write(0x00);
    spi.write(0x00);
    spi.write(0x00);

    LE = 1;
    wait_us(10);
    LE = 0;
    wait_us(10);

    OE = 0;
    secondticker.attach(&updatetime, 1);
    while( 1 )
    {   
        uint8_t bpressed = buttons;
        wait_ms(50);
        if((bpressed == buttons) && (bpressed != 0xf))
        {
            rawtime = time(NULL);
            t3 = localtime(&rawtime);
            bpressed = (~bpressed)&0x0f;
            switch(bpressed)
            {
                case 0x01:
                    t3->tm_hour += 10;
                    if(t3->tm_hour >= 30)
                    {
                        t3->tm_hour -= 30;
                    }
                    else if(t3->tm_hour >= 24)
                    {
                        t3->tm_hour -= 20;
                    }
                break;
                case 0x02:
                    t3->tm_hour += 1;
                    if((t3->tm_hour%10) == 0)
                    {
                        t3->tm_hour -= 10;
                    }
                    else if(t3->tm_hour >= 24)
                    {
                        t3->tm_hour -= 4;
                    }                       
                break;
                case 0x04:
                    t3->tm_min += 10;
                    if(t3->tm_min >= 60)
                    {
                        t3->tm_min -= 60;
                    }
                break;
                case 0x08:
                    t3->tm_min += 1;
                    if((t3->tm_min%10) == 0)
                    {
                        t3->tm_min -= 10;
                    }
                break;
            }
            set_time(mktime(t3));
            flip = 0;
            updatetime();
            flip = 1;
            wait_ms(150);
        }
    }
}

void updatetime(void)
{
    static uint8_t flipbit;
    static struct tm *t2;
    rawtime = time(NULL);
    t2 = localtime(&rawtime);

    numiclock.second_right = t2->tm_sec%10;
    numiclock.second_left = (t2->tm_sec - numiclock.second_right)/10;
    numiclock.minute_right = t2->tm_min%10;
    numiclock.minute_left = (t2->tm_min - numiclock.minute_right)/10;
    numiclock.hour_right = t2->tm_hour%10;
    numiclock.hour_left = (t2->tm_hour-numiclock.hour_right)/10;

    spi.write(numbers[numiclock.hour_left]);
    if(flip)
    {
        if(flipbit == 1)
        {
                spi.write((numbers[numiclock.hour_right])+0x80);
                flipbit = 0;
        }
        else
        {
                spi.write(numbers[numiclock.hour_right]);
                flipbit = 1;
        }
    }
    else
    {
        spi.write(numbers[numiclock.hour_right]);
    }
    spi.write(numbers[numiclock.minute_left]);
    spi.write(numbers[numiclock.minute_right]);
        
    LE = 1;
    wait_us(10);
    LE = 0;
    wait_us(10); 
}    
 
/* RTC init function */
void MX_RTC_Init(void)
{
 
  RTC_TimeTypeDef sTime;
  RTC_DateTypeDef sDate;
 
    /**Initialize RTC and set the Time and Date
    */
  hrtc.Instance = RTC;
  hrtc.Init.HourFormat = RTC_HOURFORMAT_24;
  hrtc.Init.AsynchPrediv = 124;
  hrtc.Init.SynchPrediv = 1999;
  hrtc.Init.OutPut = RTC_OUTPUT_DISABLE;
  hrtc.Init.OutPutPolarity = RTC_OUTPUT_POLARITY_HIGH;
  hrtc.Init.OutPutType = RTC_OUTPUT_TYPE_OPENDRAIN;
  status = HAL_RTC_Init(&hrtc);
 
  sTime.Hours = 0x0;
  sTime.Minutes = 0x0;
  sTime.Seconds = 0x0;
  sTime.DayLightSaving = RTC_DAYLIGHTSAVING_NONE;
  sTime.StoreOperation = RTC_STOREOPERATION_RESET;
  HAL_RTC_SetTime(&hrtc, &sTime, RTC_FORMAT_BCD);
 
  sDate.WeekDay = RTC_WEEKDAY_MONDAY;
  sDate.Month = RTC_MONTH_JANUARY;
  sDate.Date = 0x1;
  sDate.Year = 0x0;
 
  HAL_RTC_SetDate(&hrtc, &sDate, RTC_FORMAT_BCD);
 
}