/******************************************************************************
 *
 *  Copyright 2018 ASAHI KASEI MICRODEVICES CORPORATION, Japan
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 ******************************************************************************/
#include "my-ble-hardware.h"

#ifdef USE_BUTTON1
#define MY_INTERRUPT1 BUTTON1 /* p13 */
#else
#define MY_INTERRUPT1 p11
#endif

#ifdef USE_BUTTON2
#define MY_INTERRUPT2 BUTTON2 /* p14 */
#else
#define MY_INTERRUPT2 p12
#endif

#define LED_ON  (0)
#define LED_OFF (1)

I2C my_i2c(I2C_SDA0, I2C_SCL0);
SPI my_spi(SPI_PSELMOSI0, SPI_PSELMISO0, SPI_PSELSCK0);
DigitalOut my_spi_cs(SPI_PSELSS0);

InterruptIn my_interrupt1(MY_INTERRUPT1);
InterruptIn my_interrupt2(MY_INTERRUPT2);

DigitalOut my_gpio1(p30, 0);
DigitalOut my_gpio2(p31, 0);
DigitalOut my_led1(LED1, LED_OFF);
DigitalOut my_led2(LED2, LED_OFF);
DigitalOut ble_status(LED3, LED_OFF);
DigitalOut system_status(LED4, LED_OFF);

AnalogIn my_ad1(p3);
AnalogIn my_ad2(p4);

#ifndef NDEBUG
Serial debug_uart(TX_PIN_NUMBER, RX_PIN_NUMBER, 9600);
#endif

void set_led(MY_LED led, bool on) {
    switch (led) {
    case MY_LED1:
        if (on) {
            my_led1 = LED_ON;
        } else {
            my_led1 = LED_OFF;
        }
        break;
    case MY_LED2:
        if (on) {
            my_led2 = LED_ON;
        } else {
            my_led2 = LED_OFF;
        }
        break;
    case BLEST_LED:
        if (on) {
            ble_status = LED_ON;
        } else {
            ble_status = LED_OFF;
        }
        break;
    case SYSST_LED:
        if (on) {
            system_status = LED_ON;
        } else {
            system_status = LED_OFF;
        }
        break;
    }
}

void set_isr(MY_INTERRUPT interrupt, Callback<void()> fp) {
    switch (interrupt) {
    case MY_INT1_RISE:
        if (fp) {
            my_interrupt1.rise(fp);
            my_interrupt1.enable_irq();
        } else {
            my_interrupt1.disable_irq();
        }
        break;
    case MY_INT1_FALL:
        if (fp) {
            my_interrupt1.fall(fp);
            my_interrupt1.enable_irq();
        } else {
            my_interrupt1.disable_irq();
        }
        break;
    case MY_INT2_RISE:
        if (fp) {
            my_interrupt2.rise(fp);
            my_interrupt2.enable_irq();
        } else {
            my_interrupt2.disable_irq();
        }
        break;
    case MY_INT2_FALL:
        if (fp) {
            my_interrupt2.fall(fp);
            my_interrupt2.enable_irq();
        } else {
            my_interrupt2.disable_irq();
        }
        break;
    }
}
