/******************************************************************************
 *
 *  Copyright 2018 ASAHI KASEI MICRODEVICES CORPORATION, Japan
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 ******************************************************************************/
#pragma once
#include <mbed.h>
#include "my-ble-service.h"
#include "my-ble-hardware.h"

/** Utility macro
 */
#ifndef ARRAY_SIZE
#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof((arr)[0]))
#endif

#define MAKE_U16(U8H, U8L) \
    (uint16_t)(((uint16_t)(U8H) << 8) | (uint16_t)(U8L))

#define MAKE_S16(U8H, U8L) \
    (int16_t)(((uint16_t)(U8H) << 8) | (uint16_t)(U8L))

/** BLE service instance */
extern MyBLEservice* MY_BLE;

/** Don't edit these definition */
#define MY_SUCCESS (0)
#define MY_ERROR   (-1)

enum my_ble_trigger_t {
    MY_TRIGGER_TIMER     = 0x01,
    MY_TRIGGER_INT1_RISE = 0x10,
    MY_TRIGGER_INT1_FALL = 0x20,
    MY_TRIGGER_INT2_RISE = 0x40,
    MY_TRIGGER_INT2_FALL = 0x80
};

/* prototype of function. don't edit this */
uint32_t my_ble_init(void);
void my_ble_timer(void);
void my_ble_int1_rise(void);
void my_ble_int1_fall(void);
void my_ble_int2_rise(void);
void my_ble_int2_fall(void);
void my_ble_received(const uint32_t data);
